/*
 * Decompiled with CFR 0.152.
 */
package game.Weapons;

import game.Audio.AudioPlayer;
import game.Main;
import game.Pieces.Brass;
import game.Pieces.Projectile;
import game.Weapons.Gun;
import java.awt.Color;

public class M77
extends Gun {
    private String cycleSound;
    private int ejTicks;

    public M77() {
        super(Gun.GUN.M77);
        this.reloadSound = "ReloadM77";
        this.cycleSound = "CycleM77";
        this.reloadTime = 2500L;
        this.chamberTime = 1050L;
        this.gunName = "M77";
        this.magSize = 3;
        this.ammoLoaded = 3;
        this.ammoCapacity = 9;
        this.ammoExtra = 9;
        this.damage = 115.0;
        this.spread = 0.0;
        this.xOffset = -3;
        this.yOffset = 21;
        this.velocity = 42.0;
        this.knock = 25.0;
        this.hits = 5;
    }

    @Override
    public void shoot() {
        if (this.canShoot()) {
            Main.handler.addObjectAsync(new Projectile(this));
            AudioPlayer.playSound("Sniper", 1.0f, 0.4f);
            if (this.ammoLoaded > 1) {
                AudioPlayer.playSound(this.cycleSound);
            }
            this.onShotFired();
            this.ejTicks = 0;
        }
    }

    @Override
    public void tick() {
        super.tick();
        ++this.ejTicks;
        if (this.ejTicks == 20 && !this.chambered) {
            Main.handler.addObjectAsync(new Brass(this.offsetPointX(this.xOffset, this.yOffset - 9), this.offsetPointY(this.xOffset, this.yOffset - 9), 4, 2, 3.0 + 2.0 * this.r.nextDouble(), Main.player.getAngle() - 1.7453292519943295));
        }
    }

    @Override
    public void onSwapFrom() {
        super.onSwapFrom();
        AudioPlayer.stopSound(this.cycleSound);
    }

    @Override
    public void onSwapTo() {
        super.onSwapTo();
        if (!this.chambered && this.ammoLoaded > 0) {
            AudioPlayer.playSound(this.cycleSound);
        }
    }

    @Override
    public void reload() {
        if (!this.reloading && this.ammoExtra > 0 && this.ammoLoaded < this.magSize) {
            AudioPlayer.playSound(this.reloadSound);
            this.reloading = true;
            this.ticks = 20L;
        }
    }

    @Override
    public void makeRoundSpecial(Projectile projectile) {
        projectile.angleMulti = 0.1;
        projectile.color = new Color(243, 144, 0);
        projectile.hits += 3;
        projectile.damage *= 1.72;
        projectile.magnitude *= 1.15;
        projectile.knockBack *= 1.2;
    }
}

