/*
 * Decompiled with CFR 0.152.
 */
package game.Weapons;

import game.Audio.AudioPlayer;
import game.Main;
import game.Pieces.Brass;
import game.Pieces.Projectile;
import game.Weapons.Gun;
import java.awt.Color;

public class Judge
extends Gun {
    public Judge() {
        super(Gun.GUN.Judge);
        this.reloadSound = "ReloadJudge";
        this.reloadTime = 3500L;
        this.chamberTime = 250L;
        this.gunName = "Judge";
        this.magSize = 5;
        this.ammoLoaded = 5;
        this.ammoCapacity = 10;
        this.ammoExtra = 10;
        this.damage = 24.0;
        this.spread = 9.0;
        this.xOffset = -2;
        this.yOffset = 15;
        this.velocity = 15.0;
        this.knock = 4.0;
        this.isSidearm = true;
    }

    @Override
    public void shoot() {
        if (this.canShoot()) {
            for (int i = 0; i < 4; ++i) {
                Main.handler.addObjectAsync(new Projectile(this));
            }
            if (this.ammoLoaded > 1) {
                AudioPlayer.playSound("CockJudge");
            }
            this.onShotFired();
            AudioPlayer.playSound("Pistol2", 0.75f, 0.85f);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.reloadTicks == 30L) {
            for (int i = 0; i < this.magSize; ++i) {
                Main.handler.addObjectAsync(new Brass(this.offsetPointX(this.xOffset, this.yOffset - 2) + 4.0 * this.r.nextDouble(), this.offsetPointY(this.xOffset, this.yOffset - 2) + 4.0 * this.r.nextDouble(), 3, 1, 3.0 * this.r.nextDouble(), Main.player.getAngle() + 1.0471975511965976, Color.RED));
            }
        }
    }

    @Override
    public int getHits() {
        return this.r.nextDouble() > 0.75 ? 2 : 1;
    }

    @Override
    public void makeRoundSpecial(Projectile projectile) {
    }
}

