/*
 * Decompiled with CFR 0.152.
 */
package game.Weapons;

import game.Audio.AudioPlayer;
import game.Main;
import game.Pieces.Projectile;
import game.Weapons.AKM;
import game.Weapons.AR15;
import game.Weapons.Judge;
import game.Weapons.M77;
import game.Weapons.Model12;
import game.Weapons.Model57;
import game.Weapons.OverUnder;
import game.Weapons.PX4Compact;
import game.Weapons.Security9;
import game.Weapons.Titan;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;

public abstract class Gun {
    protected double damage;
    protected double spread;
    protected double velocity;
    protected double knock;
    protected double reloadFactor;
    protected int xOffset;
    protected int yOffset;
    protected int ammoLoaded;
    protected int ammoCapacity;
    protected int ammoExtra;
    protected int magSize;
    protected int hits;
    protected boolean owned;
    protected boolean lockedIn;
    protected boolean isSidearm;
    protected boolean reloading;
    protected boolean shooting;
    protected boolean chambered;
    protected boolean isFullAuto;
    protected boolean specialRounds;
    protected boolean isMagIncreased;
    protected boolean isReloadImproved;
    protected long reloadTime;
    protected long chamberTime;
    protected String gunName;
    protected String reloadSound;
    protected String speedReloadSound;
    protected float reloadSoundPosition;
    protected long ticks;
    protected long reloadTicks;
    protected long chamberTicks;
    protected Random r;
    protected GUN gunId;
    protected static BufferedImage gunSheet;
    protected BufferedImage gunSprite;

    public static int getGunSpriteNum(Gun gun) {
        if (gun == null) {
            return 0;
        }
        return gun.getId().ordinal();
    }

    public static List<Gun> constructGuns() {
        List<Gun> list = Arrays.asList(new Titan(), new Judge(), new Security9(), new PX4Compact(), new Model57(), new OverUnder(), new Model12(), new M77(), new AR15(), new AKM());
        Collections.reverse(list);
        return list;
    }

    public Gun(GUN gUN) {
        this.gunId = gUN;
        this.r = new Random();
        this.hits = 1;
        this.reloadFactor = 1.0;
        this.gunSprite = gunSheet.getSubimage(0, 512 * Gun.getGunSpriteNum(this), 1024, 512);
    }

    public abstract void shoot();

    public abstract void makeRoundSpecial(Projectile var1);

    public void reload() {
        if (!this.reloading && this.ammoExtra > 0 && this.ammoLoaded < this.magSize) {
            if (this.isReloadImproved) {
                AudioPlayer.playSound(this.speedReloadSound);
            } else {
                AudioPlayer.playSound(this.reloadSound);
            }
            this.reloading = true;
        }
    }

    protected void reloadFinish() {
        int n = this.magSize - this.ammoLoaded;
        if (this.ammoExtra >= n) {
            this.ammoLoaded += n;
            this.ammoExtra -= n;
        } else {
            this.ammoLoaded += this.ammoExtra;
            this.ammoExtra = 0;
        }
        this.reloading = false;
        this.reloadTicks = 0L;
    }

    private void chamberFinish() {
        this.chambered = true;
        this.chamberTicks = 0L;
    }

    public void tick() {
        this.reloadIfNeeded();
        if (!this.chambered) {
            ++this.chamberTicks;
        }
        if (this.reloading) {
            ++this.reloadTicks;
        }
        if (this.chamberTicks > (long)this.ticksForChamber()) {
            this.chamberFinish();
        }
        if (this.reloadTicks > (long)this.ticksForReload()) {
            this.reloadFinish();
        }
    }

    public void resetAmmo() {
        this.ammoLoaded = this.magSize;
        this.ammoExtra = this.ammoCapacity;
        this.reloading = false;
        this.shooting = false;
        this.chambered = true;
        this.ticks = 0L;
        this.reloadTicks = 0L;
        this.chamberTicks = 0L;
        this.stopReloadSound();
    }

    public void onSwapFrom() {
        this.stopReloadSound();
        this.reloading = false;
        this.reloadTicks = 0L;
        this.chamberTicks = 0L;
    }

    public void onSwapTo() {
    }

    protected void stopReloadSound() {
        if (this.reloadSound != null) {
            AudioPlayer.stopSound(this.reloadSound);
        }
        if (this.speedReloadSound != null) {
            AudioPlayer.stopSound(this.speedReloadSound);
        }
    }

    public double muzzlePointX() {
        return this.offsetPointX(this.xOffset, this.yOffset);
    }

    public double offsetPointX(double d, double d2) {
        return Main.player.getX() + 10.0 + d * Math.cos(Main.player.getAngle()) + d2 * Math.sin(Main.player.getAngle());
    }

    public double muzzlePointY() {
        return this.offsetPointY(this.xOffset, this.yOffset);
    }

    public double offsetPointY(double d, double d2) {
        return Main.player.getY() + 10.0 + d2 * Math.cos(Main.player.getAngle()) - d * Math.sin(Main.player.getAngle());
    }

    public double getDamage() {
        return this.damage;
    }

    public double getSpread() {
        return this.spread;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getKnock() {
        return this.knock;
    }

    public int getMagSize() {
        return this.magSize;
    }

    public int getAmmoLoaded() {
        return this.ammoLoaded;
    }

    public int getAmmoExtra() {
        return this.ammoExtra;
    }

    public int getAmmoCapacity() {
        return this.ammoCapacity;
    }

    public int getHits() {
        return this.hits;
    }

    public boolean isShooting() {
        return this.shooting;
    }

    public boolean isFullAuto() {
        return this.isFullAuto;
    }

    public boolean isOwned() {
        return this.owned;
    }

    public boolean isLockedIn() {
        return this.lockedIn;
    }

    public boolean isSidearm() {
        return this.isSidearm;
    }

    public boolean isSpecialRounds() {
        return this.specialRounds;
    }

    public boolean isMagIncreased() {
        return this.isMagIncreased;
    }

    public boolean isReloading() {
        return this.reloading;
    }

    public boolean isReloadImproved() {
        return this.isReloadImproved;
    }

    public boolean isWielded() {
        return this == Main.player.getGunWielded();
    }

    public String getName() {
        return this.gunName;
    }

    public GUN getId() {
        return this.gunId;
    }

    public BufferedImage getSprite() {
        return this.gunSprite;
    }

    public void setDamage(double d) {
        this.damage = d;
    }

    public void setSpread(double d) {
        this.spread = d;
    }

    public void setMagSize(int n) {
        this.magSize = n;
    }

    public void setAmmoLoaded(int n) {
        this.ammoLoaded = n;
    }

    public void setAmmoExtra(int n) {
        this.ammoExtra = n;
    }

    public void setAmmoCapacity(int n) {
        this.ammoCapacity = n;
    }

    public void setShooting(boolean bl) {
        this.shooting = bl;
    }

    public void setFullAuto(boolean bl) {
        this.isFullAuto = bl;
    }

    public void setOwned(boolean bl) {
        this.owned = bl;
    }

    public void setSpecialRounds(boolean bl) {
        this.specialRounds = bl;
    }

    public void setMagIncreased(boolean bl) {
        this.isMagIncreased = bl;
    }

    public void setReloadImproved(boolean bl) {
        this.isReloadImproved = bl;
    }

    public void resetTickDivier() {
        this.ticks = 0L;
    }

    public void lockIn() {
        this.lockedIn = true;
    }

    public void unLock() {
        this.lockedIn = false;
    }

    public int getIndexOf() {
        return Main.player.getIndexOfGun(this);
    }

    public boolean isEquipped() {
        return Main.player.isEquipped(this);
    }

    public void unequip() {
        Main.player.unequip(this);
    }

    protected boolean canShoot() {
        return this.ammoLoaded > 0 && !this.reloading && this.chambered;
    }

    protected void reloadIfNeeded() {
        if (this.ammoExtra > 0 && this.ammoLoaded <= 0) {
            this.reload();
        }
    }

    protected void onShotFired() {
        --this.ammoLoaded;
        this.chambered = false;
        this.reloadIfNeeded();
    }

    protected int ticksForReload() {
        return (int)((double)(0.06f * (float)this.reloadTime) * (this.isReloadImproved ? this.reloadFactor : 1.0));
    }

    protected int ticksForChamber() {
        return (int)(0.06f * (float)this.chamberTime);
    }

    public static void loadAssets() {
        try (FileInputStream fileInputStream = new FileInputStream("./res/GunSprite.png");){
            gunSheet = ImageIO.read(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static enum GUN {
        Titan,
        Security9,
        Judge,
        PX4Compact,
        Model57,
        OverUnder,
        Model12,
        M77,
        AR15,
        AKM;

    }
}

