/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Main;
import game.Weapons.Gun;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;

public class SaveData
implements Serializable {
    private static final long serialVersionUID = 6194456681958310352L;
    private int money;
    private int level;
    private int bombs;
    private ArrayList<GunBean> gunBeans;

    public SaveData() {
        File file = new File("./res/saves");
        if (!file.exists()) {
            file.mkdirs();
        }
        this.gunBeans = new ArrayList();
    }

    public void syncToGameState() {
        this.money = Main.player.getMoneyAtRoundStart();
        this.level = Main.spawnSys.getLevel();
        this.bombs = Main.player.getBombsAtRoundStart();
        this.gunBeans.clear();
        for (int i = 0; i < Main.player.getArsenal().size(); ++i) {
            Gun gun = Main.player.getArsenal().get(i);
            GunBean gunBean2 = new GunBean();
            gunBean2.Id = gun.getId();
            gunBean2.MagSize = gun.getMagSize();
            gunBean2.AmmoCap = gun.getAmmoCapacity();
            gunBean2.GunOwned = gun.isOwned();
            gunBean2.SpecialRound = gun.isSpecialRounds();
            gunBean2.FireMode = gun.isFullAuto();
            gunBean2.MagIncreased = gun.isMagIncreased();
            gunBean2.ReloadImproved = gun.isReloadImproved();
            this.gunBeans.add(i, gunBean2);
        }
        System.out.println(MessageFormat.format("Syncing to state: Level: {0}, Money: {1}, GunsOwned: {2}", this.level, this.money, this.gunBeans.stream().filter(gunBean -> gunBean.GunOwned).count()));
    }

    public void writeToFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            fileOutputStream.close();
            System.out.println(MessageFormat.format("Writing to {3}: Level: {0}, Money: {1}, GunsOwned: {2}", this.level, this.money, this.gunBeans.stream().filter(gunBean -> gunBean.GunOwned).count(), string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static SaveData readFromFile(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            SaveData saveData = (SaveData)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
            System.out.println("Loaded game state from: " + string);
            return saveData;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setGameState() {
        Main.player.setMoney(this.money);
        Main.player.setMoneyAtRoundStart(this.money);
        Main.player.setBombs(this.bombs);
        Main.player.setBombsAtRoundStart(this.bombs);
        Main.spawnSys.setLevel(this.level);
        for (GunBean gunBean2 : this.gunBeans) {
            Gun gun = Main.player.getGun(gunBean2.Id);
            gun.setMagSize(gunBean2.MagSize);
            gun.setAmmoCapacity(gunBean2.AmmoCap);
            gun.setOwned(gunBean2.GunOwned);
            gun.setFullAuto(gunBean2.FireMode);
            gun.setSpecialRounds(gunBean2.SpecialRound);
            gun.setMagIncreased(gunBean2.MagIncreased);
            gun.setReloadImproved(gunBean2.ReloadImproved);
            gun.resetAmmo();
        }
        Main.player.autoEquip(Main.spawnSys.sidearmsOnly());
        System.out.println(MessageFormat.format("Setting state: Level: {0}, Money: {1}, GunsOwned: {2}", this.level, this.money, this.gunBeans.stream().filter(gunBean -> gunBean.GunOwned).count()));
        Main.gameState = Main.STATE.StoreMenu;
    }

    class GunBean
    implements Serializable {
        private static final long serialVersionUID = -7906334672407292428L;
        Gun.GUN Id;
        int MagSize;
        int AmmoCap;
        boolean GunOwned;
        boolean FireMode;
        boolean SpecialRound;
        boolean MagIncreased;
        boolean ReloadImproved;

        GunBean() {
        }
    }
}

