/*
 * Decompiled with CFR 0.152.
 */
package game.Pieces;

import game.Main;
import game.Pieces.GameObject;
import game.Pieces.Player;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import javax.imageio.ImageIO;

public class Reticle
extends GameObject {
    private static Player player;
    private boolean wantToLimitRange;
    private static Color COLOR_TRUE_COORDINATES;
    private static BufferedImage[] spriteSheet;
    private int ticks;
    private int spriteIndex;

    public Reticle(double d, double d2) {
        super(d, d2);
        player = Main.player;
    }

    @Override
    public void tick() {
        this.x = Main.clamp(this.x, 0.0, 800.0 * Main.getXScale());
        this.y = Main.clamp(this.y, 0.0, 600.0 * Main.getYScale());
        if (Main.gameState == Main.STATE.InGame && this.wantToLimitRange) {
            this.limitRange(200.0);
        }
        if (this.ticks++ % 4 == 0) {
            ++this.spriteIndex;
        }
    }

    public double getBoardX() {
        return this.x / (1.25 * Main.getXScale()) - player.getXOffset();
    }

    public double getBoardY() {
        return this.y / (1.25 * Main.getYScale()) - player.getYOffset();
    }

    @Override
    public void render(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (player.isReloading()) {
            graphics2D.drawImage(spriteSheet[this.spriteIndex % 8], (int)this.x - 10, (int)this.y - 10, 21, 21, null);
        } else {
            graphics2D.drawImage(spriteSheet[0], (int)this.x - 10, (int)this.y - 10, 21, 21, null);
        }
        graphics2D.setColor(COLOR_TRUE_COORDINATES);
        graphics2D.drawOval((int)this.x - 3, (int)this.y - 3, 6, 6);
    }

    private void limitRange(double d) {
        double d2 = Math.atan2(this.x - (player.getX() + 10.0), this.y - (player.getY() + 10.0));
        double d3 = Math.abs(d * Math.sin(d2));
        double d4 = Math.abs(d * Math.cos(d2));
        double d5 = player.getX() + 10.0;
        double d6 = player.getY() + 10.0;
        this.x = Main.clamp(this.x, d5 - d3, d5 + d3);
        this.y = Main.clamp(this.y, d6 - d4, d6 + d4);
    }

    public static void loadAssets() {
        try (FileInputStream fileInputStream = new FileInputStream("./res/Reticle.png");){
            BufferedImage bufferedImage = ImageIO.read(fileInputStream);
            for (int i = 0; i < 8; ++i) {
                Reticle.spriteSheet[i] = bufferedImage.getSubimage(0, i * 21, 21, 21);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        COLOR_TRUE_COORDINATES = new Color(255, 255, 255, 11);
        spriteSheet = new BufferedImage[8];
    }
}

