/*
 * Decompiled with CFR 0.152.
 */
package game.Pieces;

import game.Main;
import game.Pieces.Bomb;
import game.Pieces.GameObject;
import game.Weapons.Gun;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class Player
extends GameObject {
    public static final int NUMSPRITECYCLES = 8;
    public static final int NUMGUNS = Gun.GUN.values().length;
    private Gun gunWielded;
    private Gun gunPrimary;
    private Gun gunSecondary;
    private Gun gunSidearm;
    private List<Gun> arsenal = Gun.constructGuns();
    private Map<String, Gun> arsenalStringMap = new HashMap<String, Gun>();
    private Map<Gun.GUN, Gun> arsenalEnumMap = new HashMap<Gun.GUN, Gun>();
    private double angle;
    private double speed;
    private double xOffset;
    private double yOffset;
    private int ticks;
    private static BufferedImage spriteSheet;
    private static BufferedImage[][] playerSprites;
    private int money;
    private int moneyAtRoundStart;
    private int bombs;
    private int bombsAtRoundStart;
    private int spriteNum;
    private int gunNum;

    public Player(double d, double d2) {
        super(d, d2);
        this.arsenal.stream().forEach(gun -> {
            this.arsenalStringMap.put(gun.getName(), (Gun)gun);
            this.arsenalEnumMap.put(gun.getId(), (Gun)gun);
        });
        this.gunSidearm = this.getGun(Gun.GUN.Titan);
        this.gunSidearm.setOwned(true);
        this.gunWielded = this.gunSidearm;
        this.speed = 2.0;
    }

    public Rectangle getBounds() {
        return this.getBounds(0.0, 0.0);
    }

    private Rectangle getBounds(double d, double d2) {
        return new Rectangle((int)(this.x + d), (int)(this.y + d2), 20, 20);
    }

    public Polygon getSightBounds() {
        return new Polygon(new int[]{(int)this.x + 10, (int)(this.x + 10.0 + 220.0 * Math.sin(this.angle - 0.075)), (int)(this.x + 10.0 + 220.0 * Math.sin(this.angle + 0.075))}, new int[]{(int)this.y + 10, (int)(this.y + 10.0 + 220.0 * Math.cos(this.angle - 0.075)), (int)(this.y + 10.0 + 220.0 * Math.cos(this.angle + 0.075))}, 3);
    }

    @Override
    public void tick() {
        double d;
        double d2 = this.velX == 0.0 || this.velY == 0.0 ? this.velX : this.velX * HALFSQRT2;
        double d3 = d = this.velX == 0.0 || this.velY == 0.0 ? this.velY : this.velY * HALFSQRT2;
        if (!this.handler.hitsObstacle(this.getBounds(d2, 0.0))) {
            this.x += d2;
        }
        if (!this.handler.hitsObstacle(this.getBounds(0.0, d))) {
            this.y += d;
        }
        this.x = Main.clamp(this.x, 0.0, 774.0);
        this.y = Main.clamp(this.y, 0.0, 580.0);
        this.xOffset = Main.clamp(-this.x + 330.0, -160.0, 0.0);
        this.yOffset = Main.clamp(-this.y + 220.0, -140.0, 0.0);
        this.angle = Math.atan2(Main.reticle.getBoardX() - (this.x + 10.0), Main.reticle.getBoardY() - (this.y + 10.0));
        this.gunWielded.tick();
        if (this.ticks++ % 4 == 0) {
            this.detectCollision();
            this.gunNum = Gun.getGunSpriteNum(this.gunWielded);
            if (this.velX != 0.0 || this.velY != 0.0) {
                ++this.spriteNum;
            }
            this.spriteNum %= 8;
        }
    }

    public void detectCollision() {
        if (this.handler.getZombies().anyMatch(zombie -> zombie.getBounds().intersects(this.getBounds()))) {
            Main.gameState = Main.STATE.GameOver;
        }
    }

    @Override
    public void render(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.rotate(-this.angle, this.x + 10.0, this.y + 10.0);
        graphics2D.drawImage((Image)playerSprites[this.spriteNum][this.gunNum], (int)this.x, (int)this.y, null);
        graphics2D.rotate(this.angle, this.x + 10.0, this.y + 10.0);
    }

    public void renderPreview(Graphics graphics, Gun gun) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawImage(Main.backgroundSlice, 260, 360, 450, 150, null);
        graphics2D.drawImage(playerSprites[1][Gun.getGunSpriteNum(gun)], 600, 380, 80, 128, null);
        if (gun != null) {
            graphics2D.drawImage(gun.getSprite(), 260, 360, 300, 150, null);
        }
    }

    public Gun getGunWielded() {
        return this.gunWielded;
    }

    public Gun getGunPrimary() {
        return this.gunPrimary;
    }

    public Gun getGunSecondary() {
        return this.gunSecondary;
    }

    public Gun getGunSidearm() {
        return this.gunSidearm;
    }

    public Gun getGun(String string) {
        return this.arsenalStringMap.get(string);
    }

    public Gun getGun(Gun.GUN gUN) {
        return this.arsenalEnumMap.get((Object)gUN);
    }

    public Gun getGunAt(int n) {
        return this.arsenal.get(n);
    }

    public int getGunWeildedIndex() {
        return this.getIndexOfGun(this.gunWielded);
    }

    public List<Gun> getArsenal() {
        return this.arsenal;
    }

    public double getAngle() {
        return this.angle;
    }

    public double getSpeed() {
        return this.speed;
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public int getMoney() {
        return this.money;
    }

    public int getMoneyAtRoundStart() {
        return this.moneyAtRoundStart;
    }

    public int getBombs() {
        return this.bombs;
    }

    public int getBombsAtRoundStart() {
        return this.bombsAtRoundStart;
    }

    public boolean isReloading() {
        return this.gunWielded != null && this.gunWielded.isReloading();
    }

    public void setGunPrimary(Gun gun) {
        this.gunPrimary = gun;
    }

    public void setGunSecondary(Gun gun) {
        this.gunSecondary = gun;
    }

    public void setGunSidearm(Gun gun) {
        this.gunSidearm = gun;
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public void setArsenal(List<Gun> list) {
        this.arsenal = list;
    }

    public void setSpeed(double d) {
        this.speed = d;
    }

    public void setMoney(int n) {
        this.money = n;
    }

    public void setMoneyAtRoundStart(int n) {
        this.moneyAtRoundStart = n;
    }

    public void setBombs(int n) {
        this.bombs = n;
    }

    public void setBombsAtRoundStart(int n) {
        this.bombsAtRoundStart = n;
    }

    public void switchToPrimary() {
        this.switchToGun(this.gunPrimary);
    }

    public void switchToSecondary() {
        this.switchToGun(this.gunSecondary);
    }

    public void switchToSidearm() {
        this.switchToGun(this.gunSidearm);
    }

    private void switchToGun(Gun gun) {
        if (gun != null && this.gunWielded != gun) {
            this.gunWielded.onSwapFrom();
            this.gunWielded = gun;
            this.gunWielded.onSwapTo();
        }
    }

    public void switchToNext() {
        if (this.gunWielded == this.gunSidearm && this.gunSecondary != null) {
            this.switchToSecondary();
        } else {
            this.switchToPrimary();
        }
    }

    public void switchToPrevious() {
        if (this.gunWielded == this.gunPrimary && this.gunSecondary != null) {
            this.switchToSecondary();
        } else {
            this.switchToSidearm();
        }
    }

    public void resetAllAmmo() {
        this.arsenal.forEach(gun -> gun.resetAmmo());
    }

    public void autoEquip(boolean bl) {
        if (bl) {
            this.autoEquipSidearms();
        } else {
            this.autoEquip();
        }
    }

    private void autoEquip() {
        this.gunWielded = null;
        this.gunSidearm = null;
        this.gunSecondary = null;
        this.gunPrimary = null;
        if (this.gunPrimary == null && (this.numPrimariesAvailable() > 0 || this.numSidearmsAvailable() > 1)) {
            this.gunPrimary = this.arsenal.stream().filter(gun -> gun.isOwned() && !gun.isEquipped()).findFirst().get();
        }
        if (this.gunSecondary == null && (this.numPrimariesAvailable() > 0 || this.numSidearmsAvailable() > 1)) {
            this.gunSecondary = this.arsenal.stream().filter(gun -> gun.isOwned() && !gun.isEquipped()).findFirst().get();
        }
        if (this.gunSidearm == null && this.numSidearmsAvailable() > 0) {
            this.gunSidearm = this.arsenal.stream().filter(gun -> gun.isOwned() && !gun.isEquipped() && gun.isSidearm()).findFirst().get();
        }
        this.autoWield();
    }

    private void autoEquipSidearms() {
        this.gunWielded = null;
        this.gunSidearm = null;
        this.gunSecondary = null;
        this.gunPrimary = null;
        if (this.gunPrimary == null && this.numSidearmsAvailable() > 1) {
            this.gunPrimary = this.arsenal.stream().filter(gun -> gun.isOwned() && !gun.isEquipped() && gun.isSidearm()).findFirst().get();
        }
        if (this.gunSecondary == null && this.numSidearmsAvailable() > 1) {
            this.gunSecondary = this.arsenal.stream().filter(gun -> gun.isOwned() && !gun.isEquipped() && gun.isSidearm()).findFirst().get();
        }
        if (this.gunSidearm == null && this.numSidearmsAvailable() > 0) {
            this.gunSidearm = this.arsenal.stream().filter(gun -> gun.isOwned() && !gun.isEquipped() && gun.isSidearm()).findFirst().get();
        }
        this.autoWield();
    }

    private int numPrimariesAvailable() {
        return (int)this.arsenal.stream().filter(gun -> gun.isOwned() && !gun.isEquipped() && !gun.isSidearm()).count();
    }

    private int numSidearmsAvailable() {
        return (int)this.arsenal.stream().filter(gun -> gun.isOwned() && !gun.isEquipped() && gun.isSidearm()).count();
    }

    public void autoWield() {
        if (this.gunSidearm != null) {
            this.gunWielded = this.gunSidearm;
        }
        if (this.gunSecondary != null) {
            this.gunWielded = this.gunSecondary;
        }
        if (this.gunPrimary != null) {
            this.gunWielded = this.gunPrimary;
        }
    }

    public void equipPrimary(Gun gun) {
        this.equipGun(gun, 0);
    }

    public void equipSecondary(Gun gun) {
        this.equipGun(gun, 1);
    }

    public void equipSidearm(Gun gun) {
        this.equipGun(gun, 2);
    }

    private void equipGun(Gun gun, int n) {
        if (gun.isOwned() && !gun.isLockedIn()) {
            if (gun.isEquipped()) {
                gun.unequip();
            }
            if (n == 0) {
                this.gunPrimary = gun;
            }
            if (n == 1) {
                this.gunSecondary = gun;
            }
            if (n == 2) {
                this.gunSidearm = gun;
            }
        }
    }

    public boolean isEquipped(Gun gun) {
        return gun == this.gunPrimary || gun == this.gunSecondary || gun == this.gunSidearm;
    }

    public void unselectAll() {
        this.arsenal.forEach(gun -> gun.unLock());
    }

    public void unequip(Gun gun) {
        switch (this.getIndexOfGun(gun)) {
            case 0: {
                this.gunPrimary = null;
                break;
            }
            case 1: {
                this.gunSecondary = null;
                break;
            }
            case 2: {
                this.gunSidearm = null;
                break;
            }
        }
        gun.unLock();
    }

    public int getIndexOfGun(Gun gun) {
        if (gun == this.gunPrimary) {
            return 0;
        }
        if (gun == this.gunSecondary) {
            return 1;
        }
        if (gun == this.gunSidearm) {
            return 2;
        }
        return -1;
    }

    public void throwBomb() {
        if (this.bombs > 0) {
            double d = Main.distance(this.x, this.y, Main.reticle.getBoardX(), Main.reticle.getBoardY());
            double d2 = Math.min(d / 10.0, 20.0);
            Main.handler.addObjectAsync(new Bomb(this.x + 10.0, this.y + 10.0, this.angle, d2));
            --this.bombs;
        }
    }

    public Rectangle getGridNode() {
        return this.handler.getGridNode(new Point((int)this.x + 10, (int)this.y + 10));
    }

    public static void loadAssets() {
        try (FileInputStream fileInputStream = new FileInputStream("./res/PlayerSprite.png");){
            spriteSheet = ImageIO.read(fileInputStream);
            fileInputStream.close();
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < NUMGUNS; ++j) {
                    Player.playerSprites[i][j] = spriteSheet.getSubimage(20 * i, 32 * j, 20, 32);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static {
        playerSprites = new BufferedImage[8][NUMGUNS];
    }
}

