/*
 * Decompiled with CFR 0.152.
 */
package game.Pieces.Enemies;

import game.Pieces.Enemies.Zombie;

public class DodgingZombie
extends Zombie {
    private int dodgeTicks = 0;
    private boolean isDodging;
    private boolean strafeDir;
    private int ticksInSight;
    private int maxTicksInSight;
    private int ticksSinceDodge;
    private int ticksSinceStrafe;
    private double theta;

    public DodgingZombie(double d, double d2) {
        super(d, d2);
        this.health = 36 + 3 * DodgingZombie.currLevelOrMax(15);
        this.speed = 1.5 + (double)DodgingZombie.currLevelOrMax(15) * 0.015;
        this.zombieSprites = Zombie.spriteSheets[1];
        this.maxTicksInSight = this.r.nextInt(60) + 20;
        this.ticksInSight = 0;
        this.moneyValue = 23;
        this.maxAngleChangeDegrees = 10;
    }

    @Override
    public void tick() {
        if (this.ticksSinceDodge++ > 360) {
            int n = this.ticksInSight = this.isLineOfSight() ? this.ticksInSight + 1 : 0;
            if (this.ticksInSight >= this.maxTicksInSight) {
                this.initDodge();
            }
        }
        if (this.isDodging) {
            this.dodgeTick();
        } else {
            super.tick();
            if (this.isLineOfSight()) {
                double d = this.angle + (double)(this.strafeDir ? 1 : -1) * Math.PI / 2.0;
                this.velX = 1.2 * Math.sin(d);
                this.velY = 1.2 * Math.cos(d);
                this.move();
            }
        }
        if (this.ticksSinceStrafe++ > 300) {
            this.strafeDir = this.r.nextBoolean();
            this.ticksSinceStrafe = 0;
        }
    }

    private boolean isLineOfSight() {
        return this.player.getSightBounds().intersects(super.getBounds());
    }

    private void initDodge() {
        this.isDodging = true;
        this.ticksSinceDodge = 0;
        this.dodgeTicks = this.r.nextInt(21) + 20;
        this.ticksInSight = 0;
        this.theta = this.angle + (double)(this.r.nextBoolean() ? 1 : -1) * 1.0471975511965976;
        this.speed *= 1.1;
    }

    private void dodgeTick() {
        double d = 0.75 + (double)((float)this.dodgeTicks / 25.0f);
        this.theta += this.r.nextGaussian() * (double)0.1f;
        this.angle = this.getAngleToPlayer();
        this.velX = d * this.speed * Math.sin(this.theta);
        this.velY = d * this.speed * Math.cos(this.theta);
        this.move();
        if (--this.dodgeTicks <= 0) {
            this.isDodging = false;
        }
        if (this.r.nextBoolean()) {
            ++this.spriteNum;
        }
    }
}

