/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Main;
import game.Pieces.Bomb;
import game.Pieces.Player;
import game.SpawnSystem.SpawnSystem;
import game.Weapons.Gun;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class HUD {
    private static Player player;
    private static SpawnSystem spawnSys;
    private String gunInfo;
    private String levelInfo;
    private int selectedIndex;
    private double alpha;
    private double endAlpha;
    private Gun gun;
    private int bombs;

    public HUD() {
        player = Main.player;
        spawnSys = Main.spawnSys;
    }

    public void tick() {
        this.gun = player.getGunWielded();
        this.gunInfo = this.gun.getName() + "    " + this.gun.getAmmoLoaded() + "/" + this.gun.getMagSize() + "   " + this.gun.getAmmoExtra();
        this.levelInfo = "Level " + spawnSys.getLevel() + "    Zombies Remaining: " + spawnSys.getRemaining() + "     $" + player.getMoney();
        this.selectedIndex = player.getGunWeildedIndex();
        this.bombs = player.getBombs();
        this.alpha = this.calcAlpha();
        this.endAlpha = spawnSys.zedsDead() ? this.endAlpha + 1.0 : 0.0;
    }

    public void render(Graphics graphics) {
        graphics.setColor(new Color(100, 20, 20, (int)(127.0 * this.alpha)));
        graphics.fillRect(20, 20, 350, 30);
        graphics.fillRect(390, 20, 370, 30);
        graphics.setColor(new Color(100, 20, 20, (int)(255.0 * this.alpha)));
        graphics.draw3DRect(20, 20, 350, 30, true);
        graphics.draw3DRect(390, 20, 370, 30, true);
        graphics.setColor(new Color(255, 255, 255, (int)(255.0 * this.alpha)));
        graphics.setFont(new Font("Arial", 1, 16));
        graphics.drawString(this.gunInfo, 40, 42);
        graphics.drawString(this.levelInfo, 410, 42);
        for (int i = 0; i < 3; ++i) {
            graphics.setColor(new Color(255, 255, 255, (int)((double)(i == this.selectedIndex ? 255 : 63) * this.alpha)));
            graphics.drawString(String.valueOf(i + 1), 310 + i * 20, 42);
        }
        graphics.drawImage(this.gun.getSprite(), 240, 20, 60, 30, null);
        graphics.setColor(new Color(255, 255, 255, 192));
        graphics.setFont(new Font("Arial", 1, 8));
        graphics.drawString(String.valueOf(this.bombs), 226, 49);
        graphics.drawImage(Bomb.getSprite(), 210, 45, 10, 4, null);
        if (spawnSys.zedsDead()) {
            graphics.setColor(new Color(0, 0, 0, (int)this.endAlpha));
            graphics.fillRect(0, 0, 800, 600);
        }
    }

    private double calcAlpha() {
        double d = player.getY() < 50.0 ? 0.95 : 1.05;
        return Main.clamp(d * this.alpha, 0.25, 1.0);
    }
}

