/*
 * Decompiled with CFR 0.152.
 */
package game.Audio;

import game.Main;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;

public class AudioPlayer {
    private static Map<String, Sound> soundMap = new HashMap<String, Sound>();
    private static Music gameMusic;
    private static Music storeMusic;
    private static float posG;
    private static float posS;

    private static void loadSounds() {
        try {
            soundMap.put("Pistol", new Sound("./res/PistolSound.wav"));
            soundMap.put("Pistol2", new Sound("./res/PistolSound2.ogg"));
            soundMap.put("Pistol3", new Sound("./res/PistolSound3.ogg"));
            soundMap.put("Pistol4", new Sound("./res/PistolSound4.ogg"));
            soundMap.put("Pistol5", new Sound("./res/PistolSound5.ogg"));
            soundMap.put("Rifle", new Sound("./res/RifleSound.wav"));
            soundMap.put("Rifle2", new Sound("./res/RifleSound2.ogg"));
            soundMap.put("AKM", new Sound("./res/AKMSound.ogg"));
            soundMap.put("Shotgun", new Sound("./res/ShotgunSound.wav"));
            soundMap.put("Shotgun2", new Sound("./res/ShotgunSound2.ogg"));
            soundMap.put("Sniper", new Sound("./res/SniperSound.wav"));
            soundMap.put("ReloadTitan", new Sound("./res/ReloadTitanSound.ogg"));
            soundMap.put("ReloadPX4", new Sound("./res/ReloadPX4Sound.ogg"));
            soundMap.put("ReloadSec9", new Sound("./res/ReloadSec9.ogg"));
            soundMap.put("ReloadAR15", new Sound("./res/ReloadAR15Sound.ogg"));
            soundMap.put("ReloadAKM", new Sound("./res/ReloadAKMSound.ogg"));
            soundMap.put("ReloadOverUnder", new Sound("./res/ReloadOverUnderSound.ogg"));
            soundMap.put("ReloadM77", new Sound("./res/ReloadM77Sound.ogg"));
            soundMap.put("ReloadJudge", new Sound("./res/ReloadJudgeSound.ogg"));
            soundMap.put("ReloadModel57", new Sound("./res/ReloadModel57Sound.ogg"));
            soundMap.put("ReloadModel12", new Sound("./res/ReloadModel12Sound.ogg"));
            soundMap.put("SpeedReloadModel57", new Sound("./res/SpeedReloadModel57Sound.ogg"));
            soundMap.put("ReloadEmptyModel12", new Sound("./res/ReloadEmptyModel12Sound.ogg"));
            soundMap.put("CycleM77", new Sound("./res/CycleM77Sound.ogg"));
            soundMap.put("CockModel57", new Sound("./res/CockModel57Sound.ogg"));
            soundMap.put("CockJudge", new Sound("./res/CockJudgeSound.ogg"));
            soundMap.put("CycleModel12", new Sound("./res/CycleModel12Sound.ogg"));
            soundMap.put("LevelEnd", new Sound("./res/LevelEnd.ogg"));
            soundMap.put("BlipMinor", new Sound("./res/BlipMinor.wav"));
            soundMap.put("BlipMajor", new Sound("./res/BlipMajor.wav"));
        }
        catch (SlickException slickException) {
            slickException.printStackTrace();
        }
    }

    public static void init() {
        AudioPlayer.loadSounds();
        Executors.newSingleThreadExecutor().execute(() -> {
            Thread.currentThread().setName("Music Thread");
            AudioPlayer.loadMusic();
            AudioPlayer.runMusicLoop();
        });
    }

    private static void loadMusic() {
        try {
            gameMusic = new Music("./res/Dying.ogg");
            storeMusic = new Music("./res/FadedBeat.ogg");
        }
        catch (SlickException slickException) {
            slickException.printStackTrace();
        }
    }

    private static void runMusicLoop() {
        Main.STATE sTATE = null;
        Main.STATE sTATE2 = Main.gameState;
        while (true) {
            if ((sTATE2 = Main.gameState) != sTATE) {
                AudioPlayer.stateChange(sTATE2);
            }
            sTATE = sTATE2;
            Main.delay(Duration.ofMillis(50L));
        }
    }

    private static void stateChange(Main.STATE sTATE) {
        if (gameMusic.playing()) {
            posG = gameMusic.getPosition();
        }
        if (storeMusic.playing()) {
            posS = storeMusic.getPosition();
        }
        switch (sTATE) {
            case PauseMenu: 
            case GameOverWin: 
            case GameOver: {
                gameMusic.loop(0.65f, 0.25f);
                break;
            }
            case StoreMenu: {
                storeMusic.loop(1.0f, 0.15f);
                break;
            }
            default: {
                gameMusic.loop(1.0f, 0.25f);
            }
        }
        gameMusic.setPosition(posG);
        storeMusic.setPosition(posS);
    }

    private static Sound getSound(String string) {
        return soundMap.get(string);
    }

    public static void playSound(String string, float f, float f2) {
        try {
            AudioPlayer.getSound(string).play(f, f2);
        }
        catch (Exception exception) {
            System.out.println("Exception while playing a sound " + string);
        }
    }

    public static void playSound(String string) {
        AudioPlayer.playSound(string, 1.0f, 1.0f);
    }

    public static void stopSound(String string) {
        try {
            Sound sound = AudioPlayer.getSound(string);
            if (sound.playing()) {
                sound.stop();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception while stopping sound " + string);
        }
    }
}

