/*
 * Decompiled with CFR 0.152.
 */
package game.Weapons;

import game.Audio.AudioPlayer;
import game.Main;
import game.Pieces.Brass;
import game.Pieces.Projectile;
import game.Weapons.Gun;
import java.awt.Color;

public class Model12
extends Gun {
    private String cycleSound;
    private String reloadEmptySound;
    private int ejTicks;
    private int reloadTimeBase;
    private int reloadTimeEmpty;

    public Model12() {
        super(Gun.GUN.Model12);
        this.reloadSound = "ReloadModel12";
        this.reloadEmptySound = "ReloadEmptyModel12";
        this.cycleSound = "CycleModel12";
        this.reloadTimeBase = 900;
        this.reloadTimeEmpty = 1250;
        this.reloadTime = this.reloadTimeBase;
        this.chamberTime = 550L;
        this.gunName = "Model 12";
        this.magSize = 6;
        this.ammoLoaded = 6;
        this.ammoCapacity = 6;
        this.ammoExtra = 6;
        this.damage = 25.5;
        this.spread = 7.0;
        this.xOffset = -3;
        this.yOffset = 21;
        this.velocity = 17.0;
        this.knock = 5.5;
        this.isFullAuto = true;
    }

    @Override
    public void shoot() {
        if (this.canShoot()) {
            for (int i = 0; i < (this.specialRounds ? 6 : 8); ++i) {
                Main.handler.addObjectAsync(new Projectile(this));
            }
            if (this.ammoLoaded > 1) {
                AudioPlayer.playSound(this.cycleSound, 1.0f, 0.6f);
            }
            this.ejTicks = 0;
            this.onShotFired();
            AudioPlayer.playSound("Shotgun2", 1.0f, 0.275f);
        }
    }

    @Override
    public void reload() {
        if (!this.reloading && this.ammoExtra > 0 && this.ammoLoaded < this.magSize) {
            if (this.ammoLoaded > 0) {
                AudioPlayer.playSound(this.reloadSound);
                this.reloadTime = this.reloadTimeBase;
            } else {
                AudioPlayer.playSound(this.reloadEmptySound);
                this.reloadTime = this.reloadTimeEmpty;
            }
            this.reloading = true;
        }
    }

    @Override
    protected void reloadFinish() {
        --this.ammoExtra;
        ++this.ammoLoaded;
        this.reloading = false;
        this.reloadTicks = 0L;
        if (!this.shooting) {
            this.reload();
        }
    }

    @Override
    public void tick() {
        super.tick();
        ++this.ticks;
        ++this.ejTicks;
        if (this.ejTicks == 20 && !this.chambered) {
            Main.handler.addObjectAsync(new Brass(this.offsetPointX(this.xOffset, this.yOffset - 9), this.offsetPointY(this.xOffset, this.yOffset - 9), 4, 2, 3.0 + 2.0 * this.r.nextDouble(), Main.player.getAngle() - 1.7453292519943295, Color.RED));
        }
        if (this.shooting) {
            if (this.reloading && this.ammoLoaded > 0) {
                AudioPlayer.stopSound(this.reloadSound);
                AudioPlayer.stopSound(this.reloadEmptySound);
                this.reloading = false;
                this.reloadTicks = 0L;
                this.chamberTicks = 0L;
            }
            this.shoot();
        }
    }

    @Override
    public int getHits() {
        return this.r.nextDouble() > 0.35 ? 2 : 1;
    }

    @Override
    public void makeRoundSpecial(Projectile projectile) {
        projectile.angle = Main.player.getAngle();
        projectile.hits += this.r.nextInt(2) + 2;
        projectile.magnitude *= 1.1;
        projectile.knockBack *= 1.2;
        projectile.damage *= 1.375;
        projectile.color = new Color(243, 144, 0);
    }
}

