/*
 * Decompiled with CFR 0.152.
 */
package game.Pieces;

import game.Main;
import game.Pieces.Bomb;
import game.Pieces.Enemies.Zombie;
import game.Pieces.GameObject;
import game.Weapons.Gun;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class Projectile
extends GameObject {
    public double magnitude;
    public double angle;
    public double xScale;
    public double yScale;
    public double xPrev;
    public double yPrev;
    public double damage;
    public double knockBack;
    public double angleMulti;
    public int hits;
    public int ticks = 150;
    public Color color;
    private Set<Zombie> hitZombies;

    public Projectile(Gun gun) {
        super(gun.muzzlePointX(), gun.muzzlePointY());
        this.angle = Main.player.getAngle() + (new Random().nextDouble() - 0.5) * gun.getSpread() * Math.PI / 180.0;
        this.xScale = Math.sin(this.angle);
        this.yScale = Math.cos(this.angle);
        this.xPrev = this.x;
        this.yPrev = this.y;
        this.damage = gun.getDamage();
        this.knockBack = gun.getKnock();
        this.magnitude = gun.getVelocity();
        this.hits = gun.getHits();
        this.color = Color.YELLOW;
        this.angleMulti = 0.5;
        this.hitZombies = new HashSet<Zombie>();
        if (gun.isSpecialRounds()) {
            gun.makeRoundSpecial(this);
        }
    }

    public Projectile(Bomb bomb, double d) {
        super(bomb.getX(), bomb.getY());
        this.angle = d;
        this.xScale = Math.sin(d);
        this.yScale = Math.cos(d);
        this.xPrev = this.x;
        this.yPrev = this.y;
        this.damage = bomb.getDamage();
        this.knockBack = bomb.getKnock();
        this.magnitude = bomb.getVelocity();
        this.hits = 1;
        this.ticks = 6;
        this.color = new Color(200, 150, 30, 127);
        this.hitZombies = new HashSet<Zombie>();
    }

    public Line2D.Double getBounds() {
        return new Line2D.Double(this.x, this.y, this.xPrev, this.yPrev);
    }

    @Override
    public void tick() {
        this.velX = this.xScale * this.magnitude;
        this.velY = this.yScale * this.magnitude;
        this.xPrev = this.x;
        this.yPrev = this.y;
        this.x += this.velX;
        this.y += this.velY;
        this.damage -= (double)((5 - Math.min(5, this.ticks)) * 2);
        this.knockBack -= (double)(5 - Math.min(5, this.ticks));
        --this.ticks;
        if (this.hits <= 0 || this.x < -100.0 || this.x > 900.0 || this.y < -100.0 || this.y > 700.0 || this.ticks < 0) {
            this.handler.removeObjectAsync(this);
        } else {
            this.detectCollision();
        }
    }

    public void detectCollision() {
        this.handler.getZombies().filter(zombie -> zombie.getBounds().intersectsLine(this.getBounds())).filter(zombie -> !this.hitZombies.contains(zombie)).filter(zombie -> zombie.getHealth() > 0.0).forEach(zombie -> {
            zombie.damageMe(this.damage, this.angle, this.knockBack);
            this.hitZombies.add((Zombie)zombie);
            --this.hits;
            this.damage /= 1.4;
            this.magnitude /= 1.2;
            this.angle += (new Random().nextDouble() - 0.5) * this.angleMulti;
            this.xScale = Math.sin(this.angle);
            this.yScale = Math.cos(this.angle);
        });
        if (this.handler.hitsObstacle(this.getBounds())) {
            this.handler.removeObjectAsync(this);
        }
    }

    @Override
    public void render(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.color);
        graphics2D.draw(this.getBounds());
    }
}

