/*
 * Decompiled with CFR 0.152.
 */
package game.Pieces.Enemies;

import game.Main;
import game.Pieces.Enemies.Zombie;

public class ChargingZombie
extends Zombie {
    private int chargeTicks = 0;
    private boolean isCharging;
    private int ticksSinceCharge;

    public ChargingZombie(double d, double d2) {
        super(d, d2);
        this.health = 105.0 + 3.5 * (double)ChargingZombie.currLevelOrMax(30);
        this.speed = 0.7 + (double)ChargingZombie.currLevelOrMax(20) * 0.015;
        this.zombieSprites = Zombie.spriteSheets[4];
        this.moneyValue = 30;
        this.maxAngleChangeDegrees = 2;
    }

    @Override
    public void tick() {
        if (this.ticksSinceCharge++ > 330 && !this.handler.hitsObstacle(this.getSightToPlayer()) && Main.distance(this, this.player) < 225.0) {
            this.initCharge();
        }
        if (this.isCharging) {
            this.chargeTick();
        } else {
            super.tick();
        }
    }

    private void initCharge() {
        this.isCharging = true;
        this.ticksSinceCharge = 0;
        this.angle = this.getAngleToPlayer();
        this.chargeTicks = this.r.nextInt(11) + 100;
        this.speed *= 1.1;
    }

    private void chargeTick() {
        double d = 10.0f * ((float)this.chargeTicks / 60.0f);
        if (this.ticksSinceCharge < 55) {
            d = 0.0;
        } else {
            ++this.spriteNum;
        }
        this.angle = this.getAdjustedAngle(this.getAngleToPlayer(), 8.0);
        this.velX = d * Math.sin(this.angle);
        this.velY = d * Math.cos(this.angle);
        this.move();
        if (--this.chargeTicks <= 0) {
            this.isCharging = false;
        }
    }
}

