/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Audio.AudioPlayer;
import game.HUD;
import game.Handler;
import game.Inputs.KeyInput;
import game.Inputs.MouseInput;
import game.Inputs.Store;
import game.MenuHelpers;
import game.Pieces.Bomb;
import game.Pieces.DeadZed;
import game.Pieces.Enemies.Zombie;
import game.Pieces.GameObject;
import game.Pieces.Player;
import game.Pieces.Reticle;
import game.SaveData;
import game.SpawnSystem.SpawnSystem;
import game.Weapons.Gun;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class Main
extends Canvas
implements Runnable {
    private static final long serialVersionUID = -1499886446881465910L;
    private boolean running;
    private Thread gameThread;
    public static HUD hud;
    public static Store store;
    public static BufferedImage background;
    public static BufferedImage backgroundSlice;
    private static BufferedImage background1;
    private static BufferedImage background2;
    private static BufferedImage background3;
    private static BufferedImage background4;
    private static BufferedImage background5;
    private static JFrame frame;
    public static SaveData defaultSave;
    public static SaveData currentSave;
    public static SpawnSystem spawnSys;
    public static Reticle reticle;
    public static Player player;
    public static Handler handler;
    public static final int HEIGHT = 600;
    public static final int WIDTH = 800;
    public static final int XTBOUND = -160;
    public static final int YTBOUND = -140;
    public static final double SCALE = 1.25;
    public static STATE gameState;
    private static STATE prevState;

    public Main() {
        this.loadAssets();
        handler = new Handler();
        player = new Player(390.0, 270.0);
        reticle = new Reticle(390.0, 270.0);
        handler.addObject(player);
        handler.addObject(reticle);
        spawnSys = new SpawnSystem();
        store = new Store();
        hud = new HUD();
        MouseInput mouseInput = new MouseInput();
        this.addKeyListener(new KeyInput());
        this.addMouseListener(mouseInput);
        this.addMouseWheelListener(mouseInput);
        this.addMouseMotionListener(mouseInput);
        this.addMouseListener(store);
        this.addMouseMotionListener(store);
        defaultSave.syncToGameState();
        currentSave.syncToGameState();
        this.setupJFrame();
        this.start();
    }

    private void setupJFrame() {
        Dimension dimension = new Dimension(800, 600);
        frame = new JFrame("Stand Your Ground");
        frame.setPreferredSize(dimension);
        frame.setMinimumSize(dimension);
        frame.setBackground(Color.BLACK);
        frame.setDefaultCloseOperation(3);
        frame.setResizable(true);
        frame.setLocationRelativeTo(null);
        frame.setCursor(frame.getToolkit().createCustomCursor(new BufferedImage(1, 1, 2), new Point(), null));
        frame.setIconImage(new ImageIcon("./res/Oscilloshape1.JPG").getImage());
        frame.add(this);
        frame.setVisible(true);
    }

    private void loadAssets() {
        AudioPlayer.init();
        Player.loadAssets();
        Gun.loadAssets();
        Zombie.loadAssets();
        DeadZed.loadAssets();
        Store.loadAssets();
        Reticle.loadAssets();
        Bomb.loadAssets();
        try {
            background1 = ImageIO.read(new File("./res/GrassBackground.png"));
            background2 = ImageIO.read(new File("./res/StreetBackground.png"));
            background3 = ImageIO.read(new File("./res/UrbanBackground.png"));
            background4 = ImageIO.read(new File("./res/DeadendBackground.png"));
            background5 = ImageIO.read(new File("./res/TunnelBackground.png"));
            background = background1;
            backgroundSlice = background.getSubimage(0, 20, 120, 40);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public synchronized void start() {
        this.running = true;
        this.gameThread = new Thread((Runnable)this, "Main Game Thread");
        this.gameThread.start();
    }

    public synchronized void stop() {
        try {
            this.gameThread.join();
            this.running = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Launching...");
        new Main();
    }

    @Override
    public void run() {
        this.requestFocus();
        long l = System.nanoTime();
        long l2 = System.nanoTime();
        double d = 60.0;
        double d2 = 1.0E9 / d;
        double d3 = 0.0;
        long l3 = System.currentTimeMillis();
        int n = 0;
        while (this.running) {
            l2 = System.nanoTime();
            d3 += (double)(l2 - l) / d2;
            l = l2;
            while (d3 >= 1.0) {
                this.tick();
                d3 -= 1.0;
                this.render();
                ++n;
            }
            if (System.currentTimeMillis() - l3 > 1000L) {
                l3 = System.currentTimeMillis();
                System.out.println("FPS: " + n);
                n = 0;
            }
            Main.delay(Duration.ofMillis(1L));
        }
        this.stop();
    }

    private void render() {
        BufferStrategy bufferStrategy = this.getBufferStrategy();
        if (bufferStrategy == null) {
            this.createBufferStrategy(3);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)bufferStrategy.getDrawGraphics();
        double d = Main.getXScale();
        double d2 = Main.getYScale();
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillRect(0, 0, (int)(800.0 * d), (int)(600.0 * d2));
        switch (gameState) {
            case GameOver: {
                graphics2D.scale(d, d2);
                MenuHelpers.renderGameOverMenu(graphics2D);
                graphics2D.scale(1.0 / d, 1.0 / d2);
                reticle.render(graphics2D);
                break;
            }
            case GameOverWin: {
                graphics2D.scale(d, d2);
                MenuHelpers.renderGameOverWinMenu(graphics2D);
                graphics2D.scale(1.0 / d, 1.0 / d2);
                reticle.render(graphics2D);
                break;
            }
            case InGame: {
                graphics2D.scale(1.25 * d, 1.25 * d2);
                graphics2D.translate(player.getXOffset(), player.getYOffset());
                graphics2D.drawImage((Image)background, 0, 0, null);
                handler.render(graphics2D);
                graphics2D.translate(-player.getXOffset(), -player.getYOffset());
                graphics2D.scale(1.0 / (1.25 * d), 1.0 / (1.25 * d2));
                graphics2D.scale(d, d2);
                hud.render(graphics2D);
                graphics2D.scale(1.0 / d, 1.0 / d2);
                reticle.render(graphics2D);
                break;
            }
            case PauseMenu: {
                graphics2D.scale(d, d2);
                MenuHelpers.renderPauseMenu(graphics2D);
                graphics2D.scale(1.0 / d, 1.0 / d2);
                reticle.render(graphics2D);
                break;
            }
            case StartMenu: {
                graphics2D.scale(d, d2);
                MenuHelpers.renderStartMenu(graphics2D);
                graphics2D.scale(1.0 / d, 1.0 / d2);
                reticle.render(graphics2D);
                break;
            }
            case StoreMenu: {
                graphics2D.scale(d, d2);
                store.render(graphics2D);
                graphics2D.scale(1.0 / d, 1.0 / d2);
                reticle.render(graphics2D);
                break;
            }
        }
        graphics2D.dispose();
        bufferStrategy.show();
    }

    private void tick() {
        Main.adjustSize();
        switch (gameState) {
            case InGame: {
                handler.tick();
                hud.tick();
                spawnSys.tick();
                break;
            }
            default: {
                reticle.tick();
            }
        }
        if (prevState != gameState) {
            this.stateChange();
        }
        prevState = gameState;
    }

    private void stateChange() {
        hud.tick();
        this.updateBackground();
        switch (gameState) {
            case InGame: {
                if (prevState != STATE.PauseMenu) {
                    spawnSys.commence();
                }
                if (prevState == STATE.StoreMenu) {
                    currentSave.syncToGameState();
                }
                this.removeMouseMotionListener(store);
                break;
            }
            case StoreMenu: {
                this.addMouseMotionListener(store);
                currentSave.syncToGameState();
                Store.menu = Store.Menu.BuyGuns;
                store.onMenuUpdate();
                backgroundSlice = background.getSubimage(0, 20, 120, 40);
                break;
            }
        }
    }

    private void updateBackground() {
        if (spawnSys.getLevel() <= 5) {
            background = background1;
        } else if (spawnSys.getLevel() <= 10) {
            background = background2;
        } else if (spawnSys.getLevel() <= 15) {
            background = background3;
        } else if (spawnSys.getLevel() <= 20) {
            background = background4;
        } else if (spawnSys.getLevel() <= 25) {
            background = background5;
        }
    }

    public static boolean isOnEdgeX() {
        double d = -player.getX() + 330.0;
        return d > 0.0 || d < -160.0;
    }

    public static boolean isOnEdgeY() {
        double d = -player.getY() + 220.0;
        return d > 0.0 || d < -140.0;
    }

    public static double clamp(double d, double d2, double d3) {
        return Math.min(Math.max(d, d2), d3);
    }

    public static int clamp(int n, int n2, int n3) {
        return Math.min(Math.max(n, n2), n3);
    }

    public static double distance(double d, double d2, double d3, double d4) {
        return Math.sqrt(Math.pow(d3 - d, 2.0) + Math.pow(d4 - d2, 2.0));
    }

    public static double distance(GameObject gameObject, GameObject gameObject2) {
        return Main.distance(gameObject.getX(), gameObject.getY(), gameObject2.getX(), gameObject2.getY());
    }

    public static void delay(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static double getXScale() {
        Dimension dimension = frame.getSize();
        return dimension.getWidth() / 800.0;
    }

    public static double getYScale() {
        Dimension dimension = frame.getSize();
        return dimension.getHeight() / 600.0;
    }

    public static double getXOffset() {
        return (Main.getXScale() - 1.0) * 800.0 / 2.0;
    }

    private static void adjustSize() {
        double d = Math.min(Main.getXScale(), Main.getYScale());
        if (Main.getXScale() != Main.getYScale()) {
            System.out.println("Adjusting size to maintain aspect ratio - scale " + d);
            frame.setSize((int)(d * 800.0), (int)(d * 600.0));
        }
    }

    static {
        defaultSave = new SaveData();
        currentSave = new SaveData();
        gameState = STATE.StartMenu;
    }

    public static enum STATE {
        InGame,
        StoreMenu,
        StartMenu,
        GameOver,
        GameOverWin,
        PauseMenu;

    }
}

