/*
 * Decompiled with CFR 0.152.
 */
package game.Inputs;

import game.Audio.AudioPlayer;
import game.Button;
import game.Main;
import game.MenuHelpers;
import game.Pieces.Player;
import game.Weapons.Gun;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class Store
extends MouseAdapter {
    private static Player player;
    public Button[] buttons = new Button[16];
    public Button hover;
    public static BufferedImage pegboard;
    public static Menu menu;

    public Store() {
        player = Main.player;
    }

    private static Point correctMouse(Point point) {
        return new Point((int)(point.getX() / Main.getXScale()), (int)(point.getY() / Main.getYScale()));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = Store.correctMouse(mouseEvent.getPoint());
        if (Main.gameState == Main.STATE.StoreMenu) {
            Button button2 = Arrays.stream(this.buttons).filter(button -> button != null && button.inBounds(point) && button.isClickable()).findAny().orElse(null);
            if (button2 == null) {
                return;
            }
            switch (menu) {
                case BuyGuns: {
                    this.buyGun(button2.getGun(), button2.getPrice());
                    break;
                }
                case BuyAmmo: {
                    if (button2.getFirstLine().contains("Buy")) {
                        this.buyBomb(button2.getPrice());
                        break;
                    }
                    this.upgradeCapacity(button2.getGun(), button2.getAmount(), button2.getPrice());
                    break;
                }
                case BuyUpgrades: {
                    if (button2.getFirstLine().contains("Mags")) {
                        this.upgradeMagSize(button2.getGun(), button2.getAmount(), button2.getPrice());
                    }
                    if (button2.getFirstLine().contains("Auto")) {
                        this.upgradeFireMode(button2.getGun(), button2.getPrice());
                    }
                    if (button2.getFirstLine().contains("Speed")) {
                        this.upgradeReload(button2.getGun(), button2.getPrice());
                    }
                    if (!button2.getFirstLine().matches(".*(Hollow|Loads|Buck|Rounds).*")) break;
                    this.upgradeRounds(button2.getGun(), button2.getPrice());
                    break;
                }
                case SelectSidearm: {
                    player.equipSidearm(button2.getGun());
                    player.switchToSidearm();
                    this.playBlipMajor();
                    break;
                }
                case SelectPrimary: {
                    player.equipPrimary(button2.getGun());
                    player.switchToPrimary();
                    this.playBlipMajor();
                    break;
                }
                case SelectSecondary: {
                    player.equipSecondary(button2.getGun());
                    player.switchToSecondary();
                    this.playBlipMajor();
                    break;
                }
            }
            Arrays.stream(this.buttons).filter(button -> button != null).forEach(button -> button.update());
            player.setMoneyAtRoundStart(player.getMoney());
            player.setBombsAtRoundStart(player.getBombs());
            this.mouseMoved(mouseEvent);
        }
    }

    public void nextMenu() {
        switch (menu) {
            case BuyGuns: {
                menu = Menu.BuyAmmo;
                player.autoEquip(Main.spawnSys.sidearmsOnly());
                break;
            }
            case BuyAmmo: {
                menu = Menu.BuyUpgrades;
                break;
            }
            case BuyUpgrades: {
                menu = Menu.SelectSidearm;
                player.switchToSidearm();
                break;
            }
            case SelectSidearm: {
                menu = Menu.SelectPrimary;
                if (player.getGunSidearm() != null) {
                    player.getGunSidearm().lockIn();
                }
                player.switchToPrimary();
                break;
            }
            case SelectPrimary: {
                menu = Menu.SelectSecondary;
                if (player.getGunPrimary() != null) {
                    player.getGunPrimary().lockIn();
                }
                player.switchToSecondary();
                break;
            }
            case SelectSecondary: {
                menu = Menu.Final;
                if (player.getGunSecondary() == null) break;
                player.getGunSecondary().lockIn();
                break;
            }
            case Final: {
                menu = Menu.Other;
                player.unselectAll();
                Main.gameState = Main.STATE.InGame;
            }
        }
        this.onMenuUpdate();
    }

    public void prevMenu() {
        switch (menu) {
            case BuyAmmo: {
                menu = Menu.BuyGuns;
                break;
            }
            case BuyUpgrades: {
                menu = Menu.BuyAmmo;
                break;
            }
            case SelectSidearm: {
                menu = Menu.BuyUpgrades;
                break;
            }
            case SelectPrimary: {
                menu = Menu.SelectSidearm;
                if (player.getGunSidearm() != null) {
                    player.getGunSidearm().unLock();
                }
                player.switchToSidearm();
                break;
            }
            case SelectSecondary: {
                menu = Menu.SelectPrimary;
                if (player.getGunPrimary() != null) {
                    player.getGunPrimary().unLock();
                }
                player.switchToPrimary();
                break;
            }
            case Final: {
                menu = Menu.SelectSecondary;
                if (player.getGunSecondary() != null) {
                    player.getGunSecondary().unLock();
                }
                player.switchToSecondary();
            }
        }
        this.onMenuUpdate();
    }

    public void onMenuUpdate() {
        Arrays.fill(this.buttons, null);
        int n = 0;
        switch (menu) {
            case BuyGuns: {
                this.buttonHelper(n++, true, "Buy", "AKM", "$1200", "The klassic Kalashnikov_with a nice face lift_7.62x39mm, 30rd");
                this.buttonHelper(n++, true, "Buy", "AR-15", "$1100", "The classic 'Black Rifle'_with modern furniture_5.56x45mm, 30rd");
                this.buttonHelper(n++, true, "Buy", "M77", "$800", "Powerful Bolt Action Rifle_7mm Rem. Mag., 3rd");
                this.buttonHelper(n++, true, "Buy", "Model 12", "$750", "Classic Winchester Pump_Shotgun - Can slam fire_12 Gauge, 6rd");
                this.buttonHelper(n++, true, "Buy", "Over-Under", "$575", "Double-Barreled Shotgun_12 Gauge, 2rd");
                this.buttonHelper(n++, true, "Buy", "Model 57", "$525", "S&W Magnum Revolver_.41 Magnum, 6rd");
                this.buttonHelper(n++, true, "Buy", "PX4 Compact", "$425", "Modern Handgun -_Compact PX4 Storm_9x19mm, 15rd");
                this.buttonHelper(n++, true, "Buy", "Security 9", "$350", "Ruger Handgun with nice_Tiffany Blue Cerakote_9x19mm, 15rd");
                this.buttonHelper(n++, true, "Buy", "Judge", "$325", "Revolver that can shoot_.410 shot and .45 Colt_.410 Bore, 5rd");
                this.buttonHelper(n++, true, "Buy", "Titan", "", "Pocket Pistol -_Better than nothing_.25 ACP, 7rd");
                break;
            }
            case BuyAmmo: {
                this.buttonHelper(n++, true, "Increase Ammo", "AKM", "$500", "30 more rounds", 30);
                this.buttonHelper(n++, true, "Increase Ammo", "AR-15", "$475", "30 more rounds", 30);
                this.buttonHelper(n++, true, "Increase Ammo", "M77", "$300", "9 more rounds", 9);
                this.buttonHelper(n++, true, "Increase Ammo", "Model 12", "$200", "6 more shells", 6);
                this.buttonHelper(n++, true, "Increase Ammo", "Over-Under", "$200", "6 more shells", 6);
                this.buttonHelper(n++, true, "Increase Ammo", "Model 57", "$250", "12 more rounds", 12);
                this.buttonHelper(n++, true, "Increase Ammo", "PX4 Compact", "$175", "15 more rounds", 15);
                this.buttonHelper(n++, true, "Increase Ammo", "Security 9", "$150", "15 more rounds", 15);
                this.buttonHelper(n++, true, "Increase Ammo", "Judge", "$125", "10 more shells", 10);
                this.buttonHelper(n++, true, "Increase Ammo", "Titan", "$75", "21 more rounds", 21);
                this.buttonHelper(n++, true, "Buy", "Bomb", "$290", "High explosive stick_of dynamite._1 more bomb", 1);
                break;
            }
            case BuyUpgrades: {
                this.buttonHelper(n++, true, "RPK Mags", "AKM", "$600", "40-round RPK_magazines", 10);
                this.buttonHelper(n++, true, "7N23 Rounds", "AKM", "$1000", "Steel-tipped Russian_armor piercing");
                this.buttonHelper(n++, true, "Full Auto Sear", "AKM", "$1300", "Restore the AK to its_former glory");
                this.buttonHelper(n++, true, "Extended Mags", "AR-15", "$500", "40-round AR-15_magazines", 10);
                this.buttonHelper(n++, true, "M855A1 Rounds", "AR-15", "$1100", "Enhanced Penetration_Rounds (EPR)");
                this.buttonHelper(n++, true, "Drop-In Auto Sear", "AR-15", "$1100", "Give AR-15 Select Fire_Capability");
                this.buttonHelper(n++, true, "Extended Mags", "PX4 Compact", "$500", "Use full-size PX4_Storm 20-round_extended magazsines", 5);
                this.buttonHelper(n++, true, "Hollow Points", "PX4 Compact", "$350", "Anti-Zombie Hollow_Point rounds");
                this.buttonHelper(n++, true, "Penetrator Rounds", "Security 9", "$375", "Underwood Xtreme_Penetrator solid_copper +P rounds");
                this.buttonHelper(n++, true, "Bear Loads", "Model 57", "$450", "Powerful rounds suitable_for stopping bears");
                this.buttonHelper(n++, true, "Speed Loaders", "Model 57", "$400", "Load cylinder with six_rounds at once");
                this.buttonHelper(n++, true, "Hand Loads", "M77", "$500", "High pressure, High_penetration, hand-loaded_ammunition");
                this.buttonHelper(n++, true, "000 Buckshot", "Over-Under", "$425", "Triple-Ought Buckshot -_Six heavy shot per shell");
                this.buttonHelper(n++, true, "000 Buckshot", "Model 12", "$425", "Triple-Ought Buckshot -_Six heavy shot per shell");
                break;
            }
            case SelectPrimary: {
                for (n = 0; n < Player.NUMGUNS; ++n) {
                    this.buttonHelper(n, this.primaryEnabled(n), "", player.getGunAt(n).getName(), "", "");
                }
                break;
            }
            case SelectSecondary: {
                for (n = 0; n < Player.NUMGUNS; ++n) {
                    this.buttonHelper(n, this.primaryEnabled(n), "", player.getGunAt(n).getName(), "", "");
                }
                break;
            }
            case SelectSidearm: {
                for (n = 0; n < Player.NUMGUNS; ++n) {
                    this.buttonHelper(n, player.getGunAt(n).isSidearm(), "", player.getGunAt(n).getName(), "", "");
                }
                break;
            }
        }
        Arrays.stream(this.buttons).filter(button -> button != null).forEach(button -> button.update());
    }

    private boolean primaryEnabled(int n) {
        return !Main.spawnSys.sidearmsOnly() || player.getGunAt(n).isSidearm();
    }

    private static int buttonX(int n) {
        return n % 4 * 160 + 100;
    }

    private static int buttonY(int n) {
        return n / 4 * 90 + 75;
    }

    private void buttonHelper(int n, boolean bl, String string, String string2, String string3, String string4, int n2) {
        this.buttons[n] = new Button(Store.buttonX(n), Store.buttonY(n), bl, string, string2, string3, string4, n2);
    }

    private void buttonHelper(int n, boolean bl, String string, String string2, String string3, String string4) {
        this.buttonHelper(n, bl, string, string2, string3, string4, 0);
    }

    public void render(Graphics graphics) {
        Arrays.stream(this.buttons).filter(button -> button != null).forEach(button -> button.render(graphics));
        switch (menu) {
            case BuyGuns: {
                this.drawComponents(graphics, true, false, true, null);
                Button button2 = this.hover;
                if (button2 != null) {
                    button2.renderTooltip(graphics);
                }
                graphics.drawImage(pegboard, 220, 340, 384, 192, null);
                button2 = this.hover;
                if (button2 == null || button2.getGun() == null) break;
                graphics.drawImage(button2.getGun().getSprite(), 220, 340, 384, 192, null);
                button2.renderTooltip(graphics);
                break;
            }
            case BuyAmmo: {
                this.drawComponents(graphics, true, true, true, null);
                Button button3 = this.hover;
                if (button3 == null) break;
                button3.renderTooltip(graphics);
                graphics.setFont(new Font("Arial", 1, 24));
                if (button3.getGun() != null) {
                    graphics.drawString(MessageFormat.format("{0} : {1} (+ {2})", button3.getGun().getName(), button3.getGun().getMagSize(), button3.getGun().getAmmoCapacity()), 300, 450);
                    break;
                }
                graphics.drawString(MessageFormat.format("{0} : {1}", "Bombs", player.getBombs()), 300, 450);
                break;
            }
            case BuyUpgrades: {
                this.drawComponents(graphics, true, true, true, null);
                Button button4 = this.hover;
                if (button4 == null) break;
                button4.renderTooltip(graphics);
                break;
            }
            case SelectPrimary: {
                this.drawComponents(graphics, false, true, true, "SELECT PRIMARY");
                player.renderPreview(graphics, player.getGunPrimary());
                this.drawEquipped(graphics);
                break;
            }
            case SelectSidearm: {
                this.drawComponents(graphics, false, true, true, "SELECT SIDEARM");
                player.renderPreview(graphics, player.getGunSidearm());
                this.drawEquipped(graphics);
                break;
            }
            case SelectSecondary: {
                this.drawComponents(graphics, false, true, true, "SELECT SECONDARY");
                player.renderPreview(graphics, player.getGunSecondary());
                this.drawEquipped(graphics);
                break;
            }
            case Final: {
                this.drawEquippedFinal(graphics);
                MenuHelpers.renderCommand(graphics, 225, 425, "Space", "Commence Next Level");
                MenuHelpers.renderCommand(graphics, 225, 450, "1", "Save Current State to Save 1");
                MenuHelpers.renderCommand(graphics, 225, 475, "2", "Save Current State to Save 2");
                MenuHelpers.renderCommand(graphics, 225, 500, "3", "Save Current State to Save 3");
            }
        }
    }

    private void drawComponents(Graphics graphics, boolean bl, boolean bl2, boolean bl3, String string) {
        graphics.setColor(Color.WHITE);
        graphics.setFont(new Font("Arial", 1, 24));
        if (bl) {
            graphics.drawString("MONEY: $" + player.getMoney(), 340, 45);
        }
        if (string != null) {
            graphics.drawString(string, 280, 45);
        }
        graphics.setFont(new Font("Arial", 1, 12));
        if (bl2) {
            graphics.drawString("BACKSPACE", 100, 543);
        }
        if (bl3) {
            graphics.drawString("SPACE", 663, 543);
        }
        if (Main.spawnSys.sidearmsOnly()) {
            graphics.drawString("PISTOLS ONLY THIS LEVEL", 330, 65);
        }
        graphics.setFont(new Font("Arial", 1, 48));
        if (bl2) {
            graphics.drawString("\u2190", 40, 550);
        }
        if (bl3) {
            graphics.drawString("\u2192", 715, 550);
        }
    }

    private void drawEquipped(Graphics graphics) {
        graphics.setColor(Color.GRAY);
        graphics.setFont(new Font("Monospaced", 0, 12));
        graphics.drawString("Primary   :  " + (player.getGunPrimary() != null ? player.getGunPrimary().getName() : "-"), 60, 390);
        graphics.drawString("Secondary :  " + (player.getGunSecondary() != null ? player.getGunSecondary().getName() : "-"), 60, 405);
        graphics.drawString("Sidearm   :  " + (player.getGunSidearm() != null ? player.getGunSidearm().getName() : "-"), 60, 420);
        graphics.drawString("Bombs     :  " + player.getBombs(), 60, 435);
    }

    private void drawEquippedFinal(Graphics graphics) {
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.setFont(new Font("Monospaced", 0, 30));
        graphics.drawString("Primary   :  " + (player.getGunPrimary() != null ? player.getGunPrimary().getName() : "-"), 60, 150);
        graphics.drawString("Secondary :  " + (player.getGunSecondary() != null ? player.getGunSecondary().getName() : "-"), 60, 250);
        graphics.drawString("Sidearm   :  " + (player.getGunSidearm() != null ? player.getGunSidearm().getName() : "-"), 60, 350);
        graphics.drawImage(pegboard, 550, 100, 160, 80, null);
        graphics.drawImage(pegboard, 550, 200, 160, 80, null);
        graphics.drawImage(pegboard, 550, 300, 160, 80, null);
        if (player.getGunPrimary() != null) {
            graphics.drawImage(player.getGunPrimary().getSprite(), 550, 100, 160, 80, null);
        }
        if (player.getGunSecondary() != null) {
            graphics.drawImage(player.getGunSecondary().getSprite(), 550, 200, 160, 80, null);
        }
        if (player.getGunSidearm() != null) {
            graphics.drawImage(player.getGunSidearm().getSprite(), 550, 300, 160, 80, null);
        }
    }

    private void upgradeCapacity(Gun gun, int n, int n2) {
        if (gun.isOwned() && player.getMoney() >= n2) {
            AudioPlayer.playSound("BlipMajor", 1.0f, 0.7f);
            gun.setAmmoCapacity(n + gun.getAmmoCapacity());
            player.setMoney(player.getMoney() - n2);
        }
    }

    private void upgradeMagSize(Gun gun, int n, int n2) {
        if (gun.isOwned() && player.getMoney() >= n2) {
            this.playBlipMajor();
            int n3 = gun.getMagSize();
            int n4 = gun.getAmmoCapacity();
            int n5 = player.getMoney();
            gun.setMagSize(n3 + n);
            gun.setAmmoCapacity(n4 + n);
            gun.setMagIncreased(true);
            player.setMoney(n5 - n2);
        }
    }

    private void upgradeReload(Gun gun, int n) {
        if (gun.isOwned() && player.getMoney() >= n) {
            this.playBlipMajor();
            gun.setReloadImproved(true);
            player.setMoney(player.getMoney() - n);
        }
    }

    private void upgradeRounds(Gun gun, int n) {
        if (gun.isOwned() && player.getMoney() >= n) {
            this.playBlipMajor();
            gun.setSpecialRounds(true);
            player.setMoney(player.getMoney() - n);
        }
    }

    private void upgradeFireMode(Gun gun, int n) {
        if (gun.isOwned() && player.getMoney() >= n) {
            this.playBlipMajor();
            gun.setFullAuto(true);
            player.setMoney(player.getMoney() - n);
        }
    }

    private void buyGun(Gun gun, int n) {
        if (!gun.isOwned() && player.getMoney() >= n) {
            this.playBlipMajor();
            gun.setOwned(true);
            player.setMoney(player.getMoney() - n);
        }
    }

    private void buyBomb(int n) {
        if (player.getMoney() >= n) {
            this.playBlipMajor();
            player.setBombs(player.getBombs() + 1);
            player.setMoney(player.getMoney() - n);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = Store.correctMouse(mouseEvent.getPoint());
        if (Main.gameState == Main.STATE.StoreMenu) {
            this.hover = Arrays.stream(this.buttons).filter(button -> button != null).filter(button -> button.inBounds(point)).findFirst().orElse(null);
            Arrays.stream(this.buttons).filter(button -> button != null).filter(button -> button != this.hover).filter(button -> button.isActive()).forEach(button -> button.updateDisplay());
            if (this.hover == null || !this.hover.isActive()) {
                return;
            }
            if (this.hover.isClickable() && this.hover.isMainColor()) {
                this.playBlipMinor();
            }
            this.hover.updateHoverDisplay();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public static void loadAssets() {
        try (FileInputStream fileInputStream = new FileInputStream("./res/Pegboard.png");){
            pegboard = ImageIO.read(fileInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void playBlipMajor() {
        AudioPlayer.playSound("BlipMajor", 1.0f, 0.7f);
    }

    private void playBlipMinor() {
        AudioPlayer.playSound("BlipMinor", 1.0f, 0.7f);
    }

    static {
        menu = Menu.Other;
    }

    public static enum Menu {
        Other,
        BuyGuns,
        BuyAmmo,
        BuyUpgrades,
        SelectSidearm,
        SelectPrimary,
        SelectSecondary,
        Final;

    }
}

