/*
 * Decompiled with CFR 0.152.
 */
package game.Inputs;

import game.Main;
import game.Pieces.Player;
import game.Pieces.Reticle;
import game.Weapons.Gun;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public class MouseInput
extends MouseAdapter {
    private static Player player;
    private static Reticle reticle;

    public MouseInput() {
        player = Main.player;
        reticle = Main.reticle;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getButton();
        if (Main.gameState == Main.STATE.InGame) {
            if (n == 1) {
                Gun gun = player.getGunWielded();
                gun.setShooting(true);
                if (gun.isFullAuto()) {
                    gun.resetTickDivier();
                } else {
                    gun.shoot();
                }
            } else if (n == 3) {
                player.throwBomb();
            }
        } else if (Main.gameState == Main.STATE.GameOver || Main.gameState == Main.STATE.PauseMenu || Main.gameState == Main.STATE.StartMenu || Main.gameState == Main.STATE.StoreMenu) {
            // empty if block
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (Main.gameState == Main.STATE.InGame && mouseEvent.getButton() == 1) {
            player.getGunWielded().setShooting(false);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (Main.gameState == Main.STATE.InGame) {
            if (mouseWheelEvent.getWheelRotation() == -1) {
                player.switchToPrevious();
            } else if (mouseWheelEvent.getWheelRotation() == 1) {
                player.switchToNext();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        reticle.setX(mouseEvent.getX());
        reticle.setY(mouseEvent.getY());
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }
}

