/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Pieces.Blood;
import game.Pieces.Bomb;
import game.Pieces.Brass;
import game.Pieces.DeadZed;
import game.Pieces.Enemies.ChargingZombie;
import game.Pieces.Enemies.DodgingZombie;
import game.Pieces.Enemies.FastZombie;
import game.Pieces.Enemies.ThiccZombie;
import game.Pieces.Enemies.Zombie;
import game.Pieces.GameObject;
import game.Pieces.Obstacle;
import game.Pieces.Player;
import game.Pieces.Projectile;
import game.SpawnSystem.SpawnSystem;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;

public class Handler {
    private List<GameObject> gameObjs = new LinkedList<GameObject>();
    private List<GameObject> deadQueue = new LinkedList<GameObject>();
    private ConcurrentLinkedQueue<GameObject> asyncQueue = new ConcurrentLinkedQueue();
    private Random r = new Random();
    public Rectangle[][] grid = new Rectangle[32][24];
    public static final int REC_SIZE = 25;
    public static final int GRID_WIDTH = 32;
    public static final int GRID_HEIGHT = 24;
    private static Comparator<Node> compF = Comparator.comparing(Node::getF);

    public Handler() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 24; ++j) {
                this.grid[i][j] = new Rectangle(i * 25, j * 25, 25, 25);
            }
        }
    }

    public void tick() {
        this.addQueued();
        this.gameObjs.stream().forEach(gameObject -> gameObject.tick());
        this.cullDead();
    }

    private void addQueued() {
        this.asyncQueue.forEach(gameObject -> this.addObject((GameObject)this.asyncQueue.remove()));
    }

    private void cullDead() {
        this.gameObjs.removeAll(this.deadQueue);
        this.deadQueue.clear();
    }

    public void render(Graphics graphics) {
        this.gameObjs.stream().filter(gameObject -> gameObject instanceof DeadZed).forEach(gameObject -> gameObject.render(graphics));
        this.gameObjs.stream().filter(gameObject -> gameObject instanceof Blood).forEach(gameObject -> gameObject.render(graphics));
        this.gameObjs.stream().filter(gameObject -> gameObject instanceof Brass).forEach(gameObject -> gameObject.render(graphics));
        this.gameObjs.stream().filter(gameObject -> gameObject instanceof Obstacle).forEach(gameObject -> gameObject.render(graphics));
        this.gameObjs.stream().filter(gameObject -> gameObject instanceof Projectile).forEach(gameObject -> gameObject.render(graphics));
        this.gameObjs.stream().filter(gameObject -> gameObject instanceof Zombie).forEach(gameObject -> gameObject.render(graphics));
        this.gameObjs.stream().filter(gameObject -> gameObject instanceof Bomb).forEach(gameObject -> gameObject.render(graphics));
        this.gameObjs.stream().filter(gameObject -> gameObject instanceof Player).findFirst().get().render(graphics);
    }

    public void removeBlood() {
        this.gameObjs.removeIf(gameObject -> gameObject instanceof Blood);
        this.asyncQueue.removeIf(gameObject -> gameObject instanceof Blood);
    }

    public void removeDeadZeds() {
        this.gameObjs.removeIf(gameObject -> gameObject instanceof DeadZed);
        this.asyncQueue.removeIf(gameObject -> gameObject instanceof DeadZed);
    }

    public void removeBrass() {
        this.gameObjs.removeIf(gameObject -> gameObject instanceof Brass);
        this.asyncQueue.removeIf(gameObject -> gameObject instanceof Brass);
    }

    public void removeBombs() {
        this.gameObjs.removeIf(gameObject -> gameObject instanceof Bomb);
        this.asyncQueue.removeIf(gameObject -> gameObject instanceof Bomb);
    }

    public void removeProjectiles() {
        this.gameObjs.removeIf(gameObject -> gameObject instanceof Projectile);
    }

    public void removeZombies() {
        this.gameObjs.removeIf(gameObject -> gameObject instanceof Zombie);
    }

    public void removeObstacles() {
        this.gameObjs.removeIf(gameObject -> gameObject instanceof Obstacle);
    }

    public void addRandomZombie() {
        int n = this.r.nextInt(SpawnSystem.ZOMBIE.values().length);
        int n2 = this.r.nextInt(SpawnSystem.REGION.values().length);
        SpawnSystem.ZOMBIE zOMBIE = SpawnSystem.ZOMBIE.values()[n];
        SpawnSystem.REGION rEGION = SpawnSystem.REGION.values()[n2];
        this.addZombie(rEGION, zOMBIE);
    }

    private double getRegionX(SpawnSystem.REGION rEGION) {
        if (rEGION == SpawnSystem.REGION.RIGHT) {
            return 900.0;
        }
        if (rEGION == SpawnSystem.REGION.LEFT) {
            return -100.0;
        }
        return this.r.nextInt(800);
    }

    private double getRegionY(SpawnSystem.REGION rEGION) {
        if (rEGION == SpawnSystem.REGION.DOWN) {
            return 700.0;
        }
        if (rEGION == SpawnSystem.REGION.UP) {
            return -100.0;
        }
        return this.r.nextInt(600);
    }

    private Zombie makeZombie(SpawnSystem.ZOMBIE zOMBIE, double d, double d2) {
        if (zOMBIE == SpawnSystem.ZOMBIE.DODGING) {
            return new DodgingZombie(d, d2);
        }
        if (zOMBIE == SpawnSystem.ZOMBIE.FAST) {
            return new FastZombie(d, d2);
        }
        if (zOMBIE == SpawnSystem.ZOMBIE.THICC) {
            return new ThiccZombie(d, d2);
        }
        if (zOMBIE == SpawnSystem.ZOMBIE.CHARGING) {
            return new ChargingZombie(d, d2);
        }
        return new Zombie(d, d2);
    }

    public void addZombie(SpawnSystem.REGION rEGION, SpawnSystem.ZOMBIE zOMBIE) {
        this.addObjectAsync(this.makeZombie(zOMBIE, this.getRegionX(rEGION), this.getRegionY(rEGION)));
    }

    public void bloodSplat(double d, double d2, double d3, double d4, int n) {
        this.addObjectAsync(new Blood(d, d2, d3, d4));
        for (int i = 1; i < n; ++i) {
            this.addObjectAsync(new Blood(d, d2, d3 * (this.r.nextDouble() * 0.5 + 0.5), d4 + (this.r.nextDouble() - 0.5) * 1.55));
        }
    }

    public boolean hitsObstacle(Rectangle rectangle) {
        return this.getObstacles().anyMatch(obstacle -> obstacle.getBounds().intersects(rectangle));
    }

    public boolean hitsObstacle(Line2D.Double double_) {
        return this.getObstacles().anyMatch(obstacle -> obstacle.getBounds().intersectsLine(double_));
    }

    public boolean hitsObstacle(Polygon polygon) {
        return this.getObstacles().anyMatch(obstacle -> polygon.getBounds().intersects(obstacle.getBounds()));
    }

    public Rectangle getGridNode(Point point) {
        int n;
        int n2 = Handler.nodeX(point.x);
        return Handler.validGridIndex(n2, n = Handler.nodeY(point.y)) ? this.grid[n2][n] : null;
    }

    public List<Rectangle> aStar(Point point, Point point2) {
        Node[][] nodeArray = this.generateNodes();
        LinkedList<Rectangle> linkedList = new LinkedList<Rectangle>();
        HashSet<Node> hashSet = new HashSet<Node>();
        HashSet<Node> hashSet2 = new HashSet<Node>();
        Node node = nodeArray[Handler.nodeX(point.x)][Handler.nodeY(point.y)];
        Node node2 = nodeArray[Handler.nodeX(point2.x)][Handler.nodeY(point2.y)];
        linkedList.add(node2.rectangle);
        node.h = 0.0;
        node.g = 0.0;
        node.f = 0.0;
        hashSet.add(node);
        Node node3 = null;
        while (!hashSet.isEmpty() && (node3 = hashSet.stream().min(compF).get()) != node2) {
            hashSet.remove(node3);
            hashSet2.add(node3);
            int n = node3.getX();
            int n2 = node3.getY();
            Node node4 = null;
            int[][] nArrayArray = new int[][]{{n - 1, n2 - 1}, {n + 1, n2 - 1}, {n - 1, n2 + 1}, {n + 1, n2 + 1}, {n, n2 - 1}, {n, n2 + 1}, {n - 1, n2}, {n + 1, n2}};
            for (int i = 0; i < nArrayArray.length; ++i) {
                boolean bl;
                int n3 = nArrayArray[i][0];
                int n4 = nArrayArray[i][1];
                boolean bl2 = bl = i < 4;
                if (!Handler.validGridIndex(n3, n4) || hashSet2.contains(node4 = nodeArray[n3][n4]) || this.hitsObstacle(node4.rectangle) && node4 != node2 || !(node3.g + Handler.gVal(bl) < node4.g)) continue;
                node4.parent = node3;
                node4.calcH(node2);
                node4.calcG(bl);
                node4.calcF();
                hashSet.add(node4);
            }
        }
        while (node3 != node) {
            linkedList.add(0, node3.rectangle);
            node3 = node3.parent;
        }
        return linkedList;
    }

    public static int nodeX(int n) {
        return n / 25;
    }

    public static int nodeY(int n) {
        return n / 25;
    }

    public static double gVal(boolean bl) {
        return 25.0 * (bl ? GameObject.SQRT2 : 1.0);
    }

    private Node[][] generateNodes() {
        Node[][] nodeArray = new Node[32][24];
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 24; ++j) {
                nodeArray[i][j] = new Node(i, j);
            }
        }
        return nodeArray;
    }

    public static boolean validGridIndex(int n, int n2) {
        return n >= 0 && n < 32 && n2 >= 0 && n2 < 24;
    }

    public void addObjectAsync(GameObject gameObject) {
        this.asyncQueue.add(gameObject);
    }

    public void removeObjectAsync(GameObject gameObject) {
        this.deadQueue.add(gameObject);
    }

    public void addObject(GameObject gameObject) {
        this.gameObjs.add(gameObject);
    }

    public void removeObject(GameObject gameObject) {
        this.gameObjs.remove(gameObject);
    }

    public Stream<GameObject> getObjectStream() {
        return this.gameObjs.stream();
    }

    public Stream<Zombie> getZombies() {
        return this.gameObjs.stream().filter(gameObject -> gameObject instanceof Zombie).map(gameObject -> (Zombie)gameObject);
    }

    public Stream<Obstacle> getObstacles() {
        return this.gameObjs.stream().filter(gameObject -> gameObject instanceof Obstacle).map(gameObject -> (Obstacle)gameObject);
    }

    class Node {
        Node parent;
        Rectangle rectangle;
        double f = Double.POSITIVE_INFINITY;
        double g = Double.POSITIVE_INFINITY;
        double h = Double.POSITIVE_INFINITY;

        public Node(int n, int n2) {
            this.rectangle = Handler.this.grid[n][n2];
        }

        public void calcH(Node node) {
            this.h = Point.distance(this.rectangle.getCenterX(), this.rectangle.getCenterY(), node.rectangle.getCenterX(), node.rectangle.getCenterY());
        }

        public void calcG(boolean bl) {
            this.g = this.parent.g + Handler.gVal(bl);
        }

        public void calcF() {
            this.f = this.g + this.h;
        }

        public double getF() {
            return this.f;
        }

        public int getX() {
            return this.rectangle.x / 25;
        }

        public int getY() {
            return this.rectangle.y / 25;
        }
    }
}

