/*
 * Decompiled with CFR 0.152.
 */
package game.SpawnSystem;

import game.Audio.AudioPlayer;
import game.Main;
import game.Pieces.Obstacle;
import game.SpawnSystem.Level;
import game.SpawnSystem.Levels;
import game.SpawnSystem.Spawn;
import game.SpawnSystem.Wave;

public class SpawnSystem {
    private boolean doneCommencing = false;
    private boolean doneSpawning = false;
    private boolean zedsDead;
    private int lvNum = 1;
    private int wvNum = 0;
    private int ticks = 0;
    private int delayMillis = 0;
    private int zombiesRemaining;
    private Level currLevel = Levels.getLevel(this.lvNum);
    private Wave currWave;

    public void tick() {
        ++this.ticks;
        if (this.doneCommencing) {
            if (!this.doneSpawning && this.ticks > this.delayTicks()) {
                this.spawnWave(this.currWave);
            }
            if (this.getRemaining() <= 0 && !this.zedsDead) {
                this.delayMillis = 2000;
                this.ticks = 0;
                this.zedsDead = true;
                AudioPlayer.playSound("LevelEnd");
            }
            if (this.zedsDead && this.ticks > this.delayTicks()) {
                this.completeLevel();
            }
        }
    }

    private int delayTicks() {
        return (int)(0.06f * (float)this.delayMillis);
    }

    private void resetBoard() {
        Main.handler.removeBlood();
        Main.handler.removeDeadZeds();
        Main.handler.removeBrass();
        Main.handler.removeBombs();
        Main.handler.removeProjectiles();
        Main.handler.removeZombies();
        Main.handler.removeObstacles();
        Main.player.setX(390.0);
        Main.player.setY(270.0);
        Main.player.resetAllAmmo();
        Main.player.autoWield();
        Main.player.setMoneyAtRoundStart(Main.player.getMoney());
        Main.player.setBombsAtRoundStart(Main.player.getBombs());
    }

    public void completeLevel() {
        this.doneCommencing = false;
        this.doneSpawning = false;
        Main.gameState = Main.STATE.StoreMenu;
        ++this.lvNum;
        this.resetBoard();
    }

    public void commence() {
        this.currLevel = Levels.getLevel(this.lvNum);
        this.spawnLevel(this.currLevel);
    }

    private void spawnLevel(Level level) {
        this.resetBoard();
        if (this.lvNum >= 11 && this.lvNum <= 15) {
            this.addObstaclesLvl11_15();
        } else if (this.lvNum >= 16 && this.lvNum <= 20) {
            this.addObstaclesLvl16_20();
        } else if (this.lvNum >= 21) {
            this.addObstaclesLvl21_25();
        }
        this.ticks = 0;
        this.wvNum = 0;
        this.doneCommencing = true;
        this.doneSpawning = false;
        this.zedsDead = false;
        if (level == null) {
            System.out.println("Game Over. You Win.");
            Main.gameState = Main.STATE.GameOverWin;
        } else {
            this.zombiesRemaining = level.getTotalInLevel();
            this.delayMillis = level.getDelay();
            this.currWave = level.getWaves().get(this.wvNum);
        }
    }

    private void spawnWave(Wave wave) {
        wave.getSpawns().stream().forEach(this::spawn);
        this.delayMillis = wave.getDelay();
        this.ticks = 0;
        if (++this.wvNum < this.currLevel.getWaves().size()) {
            this.currWave = this.currLevel.getWaves().get(this.wvNum);
        } else {
            this.doneSpawning = true;
        }
    }

    private void spawn(Spawn spawn) {
        for (int i = 0; i < spawn.getNum(); ++i) {
            Main.handler.addZombie(spawn.getRegion(), spawn.getZombie());
        }
    }

    private void addObstaclesLvl11_15() {
        Main.handler.addObjectAsync(new Obstacle(-50.0, 270.0, 428.0, 17.0));
        Main.handler.addObjectAsync(new Obstacle(585.0, 270.0, 265.0, 17.0));
        Main.handler.addObjectAsync(new Obstacle(640.0, 60.0, 87.0, 139.0));
    }

    private void addObstaclesLvl16_20() {
        Main.handler.addObjectAsync(new Obstacle(346.0, 458.0, 139.0, 87.0));
        Main.handler.addObjectAsync(new Obstacle(500.0, 458.0, 139.0, 87.0));
        Main.handler.addObjectAsync(new Obstacle(512.0, 580.0, 300.0, 60.0));
        Main.handler.addObjectAsync(new Obstacle(784.0, -50.0, 50.0, 700.0));
        Main.handler.addObjectAsync(new Obstacle(253.0, 184.0, 59.0, 103.0));
    }

    private void addObstaclesLvl21_25() {
        Main.handler.addObjectAsync(new Obstacle(-10.0, -10.0, 353.0, 260.0));
        Main.handler.addObjectAsync(new Obstacle(476.0, 348.0, 334.0, 262.0));
        Main.handler.addObjectAsync(new Obstacle(476.0, -10.0, 324.0, 260.0));
        Main.handler.addObjectAsync(new Obstacle(-10.0, 348.0, 353.0, 262.0));
    }

    public int getRemaining() {
        return this.zombiesRemaining;
    }

    public void decrementRemaining() {
        --this.zombiesRemaining;
    }

    public int getLevel() {
        return this.lvNum;
    }

    public void setLevel(int n) {
        this.lvNum = n;
    }

    public boolean zedsDead() {
        return this.zedsDead;
    }

    public boolean sidearmsOnly() {
        return this.lvNum >= 21 && this.lvNum <= 25;
    }

    public static enum ZOMBIE {
        NORMAL,
        DODGING,
        FAST,
        THICC,
        CHARGING;

    }

    public static enum REGION {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

