/*
 * Decompiled with CFR 0.152.
 */
package game.Pieces.Enemies;

import game.Handler;
import game.Main;
import game.Pieces.Blood;
import game.Pieces.DeadZed;
import game.Pieces.GameObject;
import game.Pieces.Player;
import game.SpawnSystem.SpawnSystem;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;

public class Zombie
extends GameObject {
    public static final int NUMZOMBIETYPES = SpawnSystem.ZOMBIE.values().length;
    protected double health;
    protected double angle;
    protected double speed;
    protected Random r;
    protected Player player;
    protected static BufferedImage[][] spriteSheets = new BufferedImage[NUMZOMBIETYPES][8];
    protected BufferedImage[] zombieSprites;
    protected int ticks;
    protected int spriteNum;
    protected int moneyValue = 19;
    protected int maxAngleChangeDegrees = 5;
    protected List<Rectangle> path = new LinkedList<Rectangle>();

    public Zombie(double d, double d2) {
        super(d, d2);
        this.player = Main.player;
        this.zombieSprites = spriteSheets[0];
        this.r = new Random();
        this.health = 40 + 4 * Zombie.currLevelOrMax(15);
        this.speed = 1.3 + (double)Zombie.currLevelOrMax(15) * 0.015;
    }

    @Override
    public void tick() {
        this.angle = this.determineAngle();
        this.velX = this.r.nextGaussian() + this.speed * Math.sin(this.angle);
        this.velY = this.r.nextGaussian() + this.speed * Math.cos(this.angle);
        this.move();
        this.detectCollision();
        if (this.ticks++ % 8 == 0) {
            ++this.spriteNum;
        }
        if (this.health < 20.0) {
            this.speed *= 1.0015;
        }
        if (this.ticks % 60 == 0) {
            this.findPathIfNeeded();
        }
    }

    protected double getAngleToPlayer() {
        return Math.atan2(this.player.getX() - this.x, this.player.getY() - this.y);
    }

    protected double getAngleDiff(double d) {
        double d2 = d - this.angle;
        if (d2 < -Math.PI) {
            d2 += Math.PI * 2;
        }
        if (d2 > Math.PI) {
            d2 -= Math.PI * 2;
        }
        return d2;
    }

    protected double getAdjustedAngle(double d, double d2) {
        double d3 = this.getAngleDiff(this.getAngleToPlayer());
        double d4 = d3 >= 0.0 ? 1.0 : -1.0;
        double d5 = Math.abs(d3);
        double d6 = d2 * (Math.PI / 180);
        return (this.angle + d4 * Math.min(d5, d6)) % (Math.PI * 2);
    }

    protected double determineAngle() {
        if (!this.handler.hitsObstacle(this.getSightToPlayer()) || this.path.isEmpty()) {
            return this.getAdjustedAngle(this.getAngleToPlayer(), this.maxAngleChangeDegrees);
        }
        Rectangle rectangle = this.path.get(0);
        if (rectangle == this.getGridNode() && this.path.size() > 1) {
            this.path.remove(rectangle);
            rectangle = this.path.get(0);
        }
        return Math.atan2(rectangle.getCenterX() - (this.x + 10.0), rectangle.getCenterY() - (this.y + 10.0));
    }

    protected double correctForObstacles() {
        if (!this.handler.hitsObstacle(this.getSightToPlayer())) {
            return 0.0;
        }
        for (int i = 0; i < 180; i += 10) {
            double d = (double)i * Math.PI / 180.0;
            if (!this.handler.hitsObstacle(this.getSightBounds(d))) {
                return d;
            }
            if (this.handler.hitsObstacle(this.getSightBounds(-d))) continue;
            return -d;
        }
        return 0.0;
    }

    protected void findPathIfNeeded() {
        if (this.handler.hitsObstacle(this.getSightToPlayer()) && Handler.validGridIndex(Handler.nodeX((int)this.x + 10), Handler.nodeY((int)this.y + 10))) {
            this.path = this.handler.aStar(new Point((int)this.x + 10, (int)this.y + 10), new Point((int)this.player.getX() + 10, (int)this.player.getY() + 10));
        }
    }

    public void detectCollision() {
        this.handler.getZombies().filter(zombie -> zombie != this).filter(zombie -> zombie.getBounds().intersects(this.getBounds())).forEach(zombie -> {
            double d = Math.atan2(this.x - zombie.getX(), this.y - zombie.getY());
            this.velX = 2.0 * Math.cos(d);
            this.velY = 2.0 * Math.sin(d);
            this.move();
        });
    }

    protected void move() {
        if (!this.handler.hitsObstacle(this.getBounds(this.velX, 0.0))) {
            this.x += this.velX;
        }
        if (!this.handler.hitsObstacle(this.getBounds(0.0, this.velY))) {
            this.y += this.velY;
        }
    }

    public Rectangle getBounds() {
        return this.getBounds(0.0, 0.0);
    }

    protected Rectangle getBounds(double d, double d2) {
        return new Rectangle((int)(this.x + d), (int)(this.y + d2), 20, 20);
    }

    protected Polygon getSightBounds() {
        return this.getSightBounds(0.0);
    }

    protected Line2D.Double getSightToPlayer() {
        return new Line2D.Double(this.x + 10.0, this.y + 10.0, this.player.getX() + 10.0, this.player.getY() + 10.0);
    }

    @Override
    public void render(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(-this.angle, this.x + 10.0, this.y + 10.0);
        graphics2D.drawImage((Image)this.zombieSprites[this.spriteNum % 8], (int)this.x, (int)this.y, null);
        graphics2D.rotate(this.angle, this.x + 10.0, this.y + 10.0);
    }

    public void damageMe(double d, double d2, double d3) {
        this.health -= d;
        this.handler.addObjectAsync(new Blood(this.x + 10.0, this.y + 10.0));
        this.velX = Math.sin(d2) * d3;
        this.velY = Math.cos(d2) * d3;
        this.move();
        this.handler.bloodSplat(this.x + 10.0, this.y + 10.0, d3, d2, 2 + (int)(d / 30.0));
        if (this.health <= 0.0) {
            this.player.setMoney(this.moneyValue + this.player.getMoney());
            Main.spawnSys.decrementRemaining();
            this.handler.removeObjectAsync(this);
            this.handler.addObjectAsync(new DeadZed(this.x, this.y, this.angle, this.getClass()));
        }
    }

    public double getHealth() {
        return this.health;
    }

    protected Polygon getSightBounds(double d) {
        double d2 = this.angle + d;
        return new Polygon(new int[]{(int)(this.x + 10.0 + 10.0 * Math.cos(d2) - 10.0 * Math.sin(d2)), (int)(this.x + 10.0 - 10.0 * Math.cos(d2) - 10.0 * Math.sin(d2)), (int)(this.x + 10.0 + 60.0 * Math.sin(d2))}, new int[]{(int)(this.y + 10.0 - 10.0 * Math.cos(d2) - 10.0 * Math.sin(d2)), (int)(this.y + 10.0 - 10.0 * Math.cos(d2) + 10.0 * Math.sin(d2)), (int)(this.y + 10.0 + 60.0 * Math.cos(d2))}, 3);
    }

    public Rectangle getGridNode() {
        return this.handler.getGridNode(new Point((int)this.x + 10, (int)this.y + 10));
    }

    public static void loadAssets() {
        for (int i = 1; i <= NUMZOMBIETYPES; ++i) {
            try (FileInputStream fileInputStream = new FileInputStream("./res/ZombieSprite_" + i + ".png");){
                BufferedImage bufferedImage = ImageIO.read(fileInputStream);
                for (int j = 0; j < 8; ++j) {
                    Zombie.spriteSheets[i - 1][j] = bufferedImage.getSubimage(20 * j, 0, 20, 24);
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static int currLevelOrMax(int n) {
        return Math.min(Main.spawnSys.getLevel(), n);
    }
}

