/*
 * Decompiled with CFR 0.152.
 */
package game.Pieces;

import game.Pieces.Enemies.ChargingZombie;
import game.Pieces.Enemies.DodgingZombie;
import game.Pieces.Enemies.FastZombie;
import game.Pieces.Enemies.ThiccZombie;
import game.Pieces.Enemies.Zombie;
import game.Pieces.GameObject;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import javax.imageio.ImageIO;

public class DeadZed
extends GameObject {
    private static BufferedImage[] spriteSheet = new BufferedImage[Zombie.NUMZOMBIETYPES];
    private BufferedImage sprite;
    private int ticks = 0;
    private double angle;

    public DeadZed(double d, double d2, double d3, Class<?> clazz) {
        super(d, d2);
        this.angle = d3;
        this.velX = 3.0 * Math.sin(d3 - Math.PI);
        this.velY = 3.0 * Math.cos(d3 - Math.PI);
        this.sprite = DeadZed.getImageFromClass(clazz);
    }

    @Override
    public void tick() {
        this.x += this.velX;
        this.y += this.velY;
        this.velX *= 0.8;
        this.velY *= 0.8;
        if (this.ticks >= 300) {
            this.handler.removeObjectAsync(this);
        }
        ++this.ticks;
    }

    @Override
    public void render(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(-this.angle, this.x + 10.0, this.y + 20.0);
        graphics2D.drawImage((Image)this.sprite, (int)this.x, (int)this.y, null);
        graphics2D.rotate(this.angle, this.x + 10.0, this.y + 20.0);
    }

    private static BufferedImage getImageFromClass(Class<?> clazz) {
        int n = 0;
        if (clazz == DodgingZombie.class) {
            n = 1;
        } else if (clazz == FastZombie.class) {
            n = 2;
        } else if (clazz == ThiccZombie.class) {
            n = 3;
        } else if (clazz == ChargingZombie.class) {
            n = 4;
        }
        return spriteSheet[n];
    }

    public static void loadAssets() {
        try (FileInputStream fileInputStream = new FileInputStream("./res/DeadZeds.png");){
            BufferedImage bufferedImage = ImageIO.read(fileInputStream);
            for (int i = 0; i < Zombie.NUMZOMBIETYPES; ++i) {
                DeadZed.spriteSheet[i] = bufferedImage.getSubimage(20 * i, 0, 20, 46);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

