/*
 * Decompiled with CFR 0.152.
 */
package game.Pieces;

import game.Audio.AudioPlayer;
import game.Main;
import game.Pieces.GameObject;
import game.Pieces.Projectile;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import javax.imageio.ImageIO;

public class Bomb
extends GameObject {
    private int ticks;
    private double velocity;
    private double damage;
    private double knock;
    private double angle;
    private static BufferedImage sprite;

    public Bomb(double d, double d2, double d3, double d4) {
        super(d, d2);
        this.angle = d3;
        this.velX = d4 * Math.sin(d3);
        this.velY = d4 * Math.cos(d3);
        this.knock = 15.0;
        this.damage = 45.0;
        this.velocity = 22.0;
    }

    @Override
    public void tick() {
        this.x += this.velX;
        this.y += this.velY;
        if (this.velX > 0.0 && this.handler.hitsObstacle(this.getRightBounds())) {
            this.velX *= -1.0;
        } else if (this.velX < 0.0 && this.handler.hitsObstacle(this.getLeftBounds())) {
            this.velX *= -1.0;
        } else if (this.velY > 0.0 && this.handler.hitsObstacle(this.getDownBounds())) {
            this.velY *= -1.0;
        } else if (this.velY < 0.0 && this.handler.hitsObstacle(this.getUpBounds())) {
            this.velY *= -1.0;
        }
        this.velX *= 0.9;
        this.velY *= 0.9;
        if (this.ticks == 90) {
            this.detonate();
        }
        if (this.ticks > 100) {
            Main.handler.removeObjectAsync(this);
        }
        ++this.ticks;
    }

    @Override
    public void render(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.ticks < 90) {
            graphics2D.rotate(-this.angle, this.x - 0.0, this.y - 0.0);
            graphics2D.drawImage((Image)sprite, (int)(this.x - 10.0), (int)(this.y - 4.0), null);
            graphics2D.rotate(this.angle, this.x - 0.0, this.y - 0.0);
        } else {
            graphics2D.setColor(new Color(200, 150, 30, 255 - (this.ticks - 85) * 15));
            int n = this.ticks;
            int n2 = n / 2;
            graphics2D.fillOval((int)this.x - n2, (int)this.y - n2, n, n);
        }
    }

    private void detonate() {
        AudioPlayer.playSound("Pistol2", 0.5f, 1.2f);
        float f = 50.0f;
        int n = 0;
        while ((float)n < f) {
            Main.handler.addObjectAsync(new Projectile(this, Math.PI * 2 * (double)((float)n / f)));
            ++n;
        }
    }

    public Rectangle getBounds() {
        return new Rectangle((int)this.x, (int)this.y, 10, 10);
    }

    public Line2D.Double getLeftBounds() {
        return new Line2D.Double(this.x, this.y, this.x - 10.0, this.y);
    }

    public Line2D.Double getRightBounds() {
        return new Line2D.Double(this.x, this.y, this.x + 10.0, this.y);
    }

    public Line2D.Double getUpBounds() {
        return new Line2D.Double(this.x, this.y, this.x, this.y - 10.0);
    }

    public Line2D.Double getDownBounds() {
        return new Line2D.Double(this.x, this.y, this.x, this.y + 10.0);
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getDamage() {
        return this.damage;
    }

    public double getKnock() {
        return this.knock;
    }

    public static BufferedImage getSprite() {
        return sprite;
    }

    public static void loadAssets() {
        try (FileInputStream fileInputStream = new FileInputStream("./res/Bomb.png");){
            sprite = ImageIO.read(fileInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

