/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Inputs.Store;
import game.Main;
import game.Weapons.Gun;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;

public class Button {
    private static Color COLOR_LIGHT_PURPLE = new Color(160, 160, 240);
    private static Color COLOR_DEEP_PURPLE = new Color(96, 64, 112);
    private static Color COLOR_RED_GRAY = new Color(120, 100, 100);
    private static Color COLOR_FADED_GREEN = new Color(80, 192, 128);
    private int x;
    private int y;
    private int w;
    private int h;
    private int amount;
    private String line1;
    private String line2;
    private String line3;
    private String tooltip;
    public Color displayColor;
    public Color mainColor;
    private Font font;
    private boolean clickable;
    private boolean active;
    private Gun gun;

    public Button(int n, int n2, boolean bl, String string, String string2, String string3, String string4) {
        this.x = n;
        this.y = n2;
        this.w = 120;
        this.h = 80;
        this.active = bl;
        this.line1 = string;
        this.line2 = string2;
        this.line3 = string3;
        this.tooltip = string4;
        this.gun = Main.player.getGun(string2);
        this.update();
        this.displayColor = bl ? this.mainColor : Color.DARK_GRAY;
        this.font = new Font("Ariel", 1, 12);
    }

    public Button(int n, int n2, boolean bl, String string, String string2, String string3, String string4, int n3) {
        this(n, n2, bl, string, string2, string3, string4);
        this.amount = n3;
    }

    public void render(Graphics graphics) {
        graphics.setColor(this.displayColor);
        graphics.setFont(this.font);
        graphics.draw3DRect(this.x, this.y, this.w, this.h, true);
        graphics.drawString(this.line1, this.x + 10, this.y + 20);
        graphics.drawString(this.line2, this.x + 20, this.y + 40);
        graphics.drawString(this.line3, this.x + 20, this.y + 60);
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void update() {
        switch (Store.menu) {
            case BuyGuns: {
                this.clickable = this.active && !this.gun.isOwned();
                this.mainColor = this.gun.isOwned() ? COLOR_RED_GRAY : Color.WHITE;
                break;
            }
            case BuyAmmo: {
                if (this.gun == null) {
                    this.clickable = this.active;
                    this.mainColor = Color.WHITE;
                    break;
                }
            }
            case BuyUpgrades: {
                boolean bl = this.clickable = this.active && this.gun.isOwned() && (this.line1.contains("Ammo") || this.line1.matches(".*(Hollow|Loads|Buck|Rounds).*") && !this.gun.isSpecialRounds() || this.line1.contains("Auto") && !this.gun.isFullAuto() || this.line1.contains("Mags") && !this.gun.isMagIncreased() || this.line1.contains("Speed") && !this.gun.isReloadImproved());
                this.mainColor = this.gun.isOwned() ? (this.isClickable() ? Color.WHITE : COLOR_RED_GRAY) : Color.GRAY;
                break;
            }
            default: {
                boolean bl = this.clickable = this.active && this.gun.isOwned() && !this.gun.isLockedIn() && !this.gun.isWielded();
                this.mainColor = this.gun.isOwned() ? (this.gun.isLockedIn() ? COLOR_RED_GRAY : (this.gun.isEquipped() ? (this.gun.isWielded() ? COLOR_DEEP_PURPLE : COLOR_LIGHT_PURPLE) : Color.WHITE)) : Color.GRAY;
            }
        }
    }

    public Gun getGun() {
        return this.gun;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getPrice() {
        return !this.line3.isEmpty() ? Integer.parseInt(this.line3.substring(1)) : 0;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isMainColor() {
        return this.displayColor == this.mainColor;
    }

    public void updateDisplay() {
        this.displayColor = this.mainColor;
    }

    public void updateHoverDisplay() {
        this.displayColor = this.clickable ? COLOR_FADED_GREEN : this.mainColor;
    }

    public boolean inBounds(Point point) {
        return point.getX() > (double)this.x && point.getX() < (double)(this.x + this.w) && point.getY() > (double)this.y && point.getY() < (double)(this.y + this.h);
    }

    public String getFirstLine() {
        return this.line1;
    }

    public String getSecondLine() {
        return this.line2;
    }

    public String getThirdLine() {
        return this.line3;
    }

    public void renderTooltip(Graphics graphics) {
        if (this.tooltip == null || this.tooltip.isEmpty()) {
            return;
        }
        double d = Math.min(Main.getXScale(), Main.getYScale());
        double d2 = Main.reticle.getX() / d;
        double d3 = Main.reticle.getY() / d;
        graphics.setFont(this.font);
        graphics.setColor(Color.BLACK);
        graphics.fillRect((int)d2, (int)d3, 160, 72);
        graphics.setColor(Color.WHITE);
        graphics.drawRect((int)d2, (int)d3, 160, 72);
        String[] stringArray = this.tooltip.split("_");
        for (int i = 0; i < stringArray.length; ++i) {
            graphics.drawString(stringArray[i], (int)d2 + 10, (int)d3 + 20 + i * 20);
        }
    }
}

